/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.index.IndexingCounter;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IndexingCounterManagerImpl
implements IndexingCounterManager,
IndexingCounter,
Startable {
    private final AtomicBoolean startHasBeenCalled;
    private long counter;
    private final BackingPropertySetManager backingPropertySetManager;
    private final ReadWriteLock lock;
    @VisibleForTesting
    static final String PROPERTY_KEY = "com.atlassian.jira.util.index.IndexingCounterManagerImpl.counterValue";

    public IndexingCounterManagerImpl(BackingPropertySetManager backingPropertySetManager) {
        this.backingPropertySetManager = backingPropertySetManager;
        this.counter = 0L;
        this.startHasBeenCalled = new AtomicBoolean(false);
        this.lock = new ReentrantReadWriteLock(false);
    }

    @VisibleForTesting
    PropertySet getPropertySet() {
        return (PropertySet)this.backingPropertySetManager.getPropertySetSupplier().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentValue() {
        long result;
        this.lock.readLock().lock();
        try {
            result = this.counter;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementValue() {
        this.lock.writeLock().lock();
        try {
            if (!this.startHasBeenCalled.get()) {
                throw new IllegalStateException("Called incrementValue() before start()");
            }
            long speculativeIncrement = this.counter;
            ++speculativeIncrement;
            this.getPropertySet().setLong(PROPERTY_KEY, speculativeIncrement);
            ++this.counter;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.counter;
    }

    public void start() throws Exception {
        if (this.getPropertySet().exists(PROPERTY_KEY)) {
            this.counter = this.getPropertySet().getLong(PROPERTY_KEY);
        } else {
            this.getPropertySet().setLong(PROPERTY_KEY, this.counter);
        }
        this.startHasBeenCalled.set(true);
    }
}

