/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.usermapper;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.usermapper.UserMapper;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public class UserMapperChain
implements UserMapper {
    private final Collection userMappers;
    private final Map userMapCache = new WeakHashMap();

    public UserMapperChain(Collection userMappers) {
        this.userMappers = userMappers;
    }

    @Override
    public User getUserFromEmailAddress(String emailAddress) {
        User user = (User)this.userMapCache.get(emailAddress);
        if (user != null) {
            return user;
        }
        for (Object userMapper1 : this.userMappers) {
            UserMapper userMapper = (UserMapper)userMapper1;
            user = userMapper.getUserFromEmailAddress(emailAddress);
            if (user == null) continue;
            this.userMapCache.put(emailAddress, user);
            return user;
        }
        return null;
    }
}

