/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.profile.AbstractUserProfileFragment;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PlugableUserProfileFragment
extends AbstractUserProfileFragment {
    private static final String DETAILS_PANEL_LOCATION = "webpanels.user.profile.summary.details";
    private static final String PREFERENCES_PANEL_LOCATION = "webpanels.user.profile.summary.preferences";
    private static final String ASSIGNED_PANEL_LOCATION = "webpanels.user.profile.summary.assigned";
    private static final String CUSTOM_PANEL_LOCATION = "webpanels.user.profile.summary.custom";
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();
    private final WebInterfaceManager webInterfaceManager;

    public PlugableUserProfileFragment(JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, WebInterfaceManager webInterfaceManager) {
        super(jiraAuthenticationContext, templatingEngine, velocityParamFactory);
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public String getId() {
        return "user-profile-plugable-panel";
    }

    @Override
    public String getFragmentHtml(User profileUser, User currentUser) {
        ImmutableMap context = ImmutableMap.of((Object)"profileUser", (Object)profileUser, (Object)"currentUser", (Object)currentUser);
        ArrayList descriptors = Lists.newArrayList();
        descriptors.add(this.getFirstDescriptor(DETAILS_PANEL_LOCATION, (Map<String, Object>)context));
        descriptors.add(this.getFirstDescriptor(PREFERENCES_PANEL_LOCATION, (Map<String, Object>)context));
        descriptors.add(this.getFirstDescriptor(ASSIGNED_PANEL_LOCATION, (Map<String, Object>)context));
        descriptors.addAll(this.webInterfaceManager.getDisplayableWebPanelDescriptors(CUSTOM_PANEL_LOCATION, (Map)context));
        ArrayList filteredDescriptors = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)Predicates.notNull()));
        Collections.sort(filteredDescriptors, WEIGHTED_DESCRIPTOR_COMPARATOR);
        return this.getHtmlFromDescriptors(filteredDescriptors, (Map<String, Object>)context);
    }

    private String getHtmlFromDescriptors(List<WebPanelModuleDescriptor> descriptors, Map<String, Object> context) {
        StringBuilder sb = new StringBuilder();
        for (WebPanelModuleDescriptor descriptor : descriptors) {
            sb.append(((WebPanel)descriptor.getModule()).getHtml(context));
        }
        return sb.toString();
    }

    private WebPanelModuleDescriptor getFirstDescriptor(String location, Map<String, Object> context) {
        List descriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, context);
        if (!descriptors.isEmpty()) {
            return (WebPanelModuleDescriptor)descriptors.get(0);
        }
        return null;
    }
}

