/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.user.ExternalEntityStore;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizExternalEntityStore
implements ExternalEntityStore {
    public static final String ENTITY_NAME_EXTERNAL_ENTITY = "ExternalEntity";
    private static final String ENTITY_TYPE = OfbizExternalEntityStore.class.getName();
    private final GenericDelegator genericDelegator;
    private final ConcurrentOperationMap<String, Long> concurrentOperationMap = new ConcurrentOperationMapImpl();

    public OfbizExternalEntityStore(GenericDelegator genericDelegator) {
        this.genericDelegator = genericDelegator;
    }

    @Override
    public Long createIfDoesNotExist(String name) throws IllegalArgumentException, DataAccessException {
        if (name == null) {
            throw new IllegalArgumentException("ExternalEntity user name must not be null.");
        }
        Callable<Long> operation = this.createCallableOperation(name);
        try {
            return (Long)this.concurrentOperationMap.runOperation((Object)name, operation);
        }
        catch (ExecutionException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private Callable<Long> createCallableOperation(final String name) {
        return new Callable<Long>(){

            @Override
            public Long call() {
                Map<String, Object> externalEntityParameters = new PrimitiveMap.Builder().add("name", IdentifierUtils.toLowerCase((String)name)).add("type", ENTITY_TYPE).toMap();
                try {
                    Long idForName;
                    List entitiesByName = OfbizExternalEntityStore.this.genericDelegator.findByAnd(OfbizExternalEntityStore.ENTITY_NAME_EXTERNAL_ENTITY, externalEntityParameters);
                    if (entitiesByName.isEmpty()) {
                        GenericValue entityGV = EntityUtils.createValue(OfbizExternalEntityStore.ENTITY_NAME_EXTERNAL_ENTITY, externalEntityParameters);
                        idForName = entityGV.getLong("id");
                    } else if (entitiesByName.size() == 1) {
                        idForName = ((GenericValue)entitiesByName.get(0)).getLong("id");
                    } else {
                        ArrayList filteredGvs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)entitiesByName, (Predicate)new Predicate<GenericValue>(){

                            public boolean apply(@Nullable GenericValue input) {
                                return name.equals(input.getString("name"));
                            }
                        }));
                        if (filteredGvs.size() == 1) {
                            idForName = ((GenericValue)filteredGvs.get(0)).getLong("id");
                        } else {
                            throw new DataAccessException("There is more than one row in the ExternalEntity table for name: " + name);
                        }
                    }
                    return idForName;
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException((Throwable)e);
                }
            }
        };
    }
}

