/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultUserHistoryManager
implements UserHistoryManager {
    private final UserHistoryStore store;

    public DefaultUserHistoryManager(@Nonnull UserHistoryStore store) {
        this.store = (UserHistoryStore)Assertions.notNull((String)"store", (Object)store);
    }

    public void addUserToHistory(UserHistoryItem.Type type, User user, User entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        this.addItemToHistory(type, user, ApplicationUsers.getKeyFor((User)entity), null);
    }

    public void addUserToHistory(UserHistoryItem.Type type, ApplicationUser user, ApplicationUser entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        this.addItemToHistory(type, user, entity.getKey(), null);
    }

    public void addItemToHistory(@Nonnull UserHistoryItem.Type type, @Nonnull User user, @Nonnull String entityId) {
        this.addItemToHistory(type, user, entityId, null);
    }

    public void addItemToHistory(UserHistoryItem.Type type, ApplicationUser user, String entityId) {
        this.addItemToHistory(type, user, entityId, null);
    }

    public void addItemToHistory(@Nonnull UserHistoryItem.Type type, @Nullable User user, @Nonnull String entityId, @Nullable String data) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"entityId", (Object)entityId);
        this.store.addHistoryItem(ApplicationUsers.from((User)user), new UserHistoryItem(type, entityId, data));
    }

    public void addItemToHistory(UserHistoryItem.Type type, ApplicationUser user, String entityId, String data) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"entityId", (Object)entityId);
        this.store.addHistoryItem(user, new UserHistoryItem(type, entityId, data));
    }

    public boolean hasHistory(@Nonnull UserHistoryItem.Type type, @Nonnull User user) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"user", (Object)user);
        List<UserHistoryItem> history = this.store.getHistory(type, ApplicationUsers.from((User)user));
        return history != null && !history.isEmpty();
    }

    public boolean hasHistory(UserHistoryItem.Type type, ApplicationUser user) {
        Assertions.notNull((String)"type", (Object)type);
        Assertions.notNull((String)"user", (Object)user);
        List<UserHistoryItem> history = this.store.getHistory(type, user);
        return history != null && !history.isEmpty();
    }

    @Nonnull
    public List<UserHistoryItem> getHistory(@Nonnull UserHistoryItem.Type type, @Nullable User user) {
        Assertions.notNull((String)"type", (Object)type);
        return this.store.getHistory(type, ApplicationUsers.from((User)user));
    }

    public List<UserHistoryItem> getHistory(UserHistoryItem.Type type, ApplicationUser user) {
        Assertions.notNull((String)"type", (Object)type);
        return this.store.getHistory(type, user);
    }

    public void removeHistoryForUser(@Nonnull User user) {
        Assertions.notNull((String)"user", (Object)user);
        this.store.removeHistoryForUser(ApplicationUsers.from((User)user));
    }

    public void removeHistoryForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        this.store.removeHistoryForUser(user);
    }
}

