/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operator.Operator;
import electric.xml.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkRatioClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(WorkRatioClauseXmlHandler.class);
    private static final String WORK_RATIO_ELEMENT_NAME = "workratio";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String MIN_SUFFIX = "min";
    private static final String MAX_SUFFIX = "max";

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        boolean isMin;
        String xmlFieldId = el.getName();
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a work ratio clause for element with name '" + xmlFieldId + "' and can not find a clause name to map to."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        String nameAttr = el.getAttributeValue(NAME_ATTR);
        if (StringUtils.isBlank((String)nameAttr)) {
            log.warn((Object)("Malformed workratio parameter: no name attribute specified in element '" + el.toString() + "'."));
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        String[] nameParts = nameAttr.split(":");
        if (nameParts.length != 2) {
            log.warn((Object)("Malformed workratio parameter: unexpected number of parts in name attribute '" + nameAttr + "'."));
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        String suffix = nameParts[1];
        if (MIN_SUFFIX.equals(suffix)) {
            isMin = true;
        } else if (MAX_SUFFIX.equals(suffix)) {
            isMin = false;
        } else {
            log.warn((Object)("Malformed workratio parameter: unknown name suffix '" + suffix + "'."));
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        String valueStr = el.getAttributeValue(VALUE_ATTR);
        Long value = null;
        if (!StringUtils.isBlank((String)valueStr)) {
            try {
                value = new Long(valueStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (value == null) {
            log.warn((Object)("Malformed workratio parameter: bad value '" + valueStr + "'."));
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        Clause clause = isMin ? JqlQueryBuilder.newClauseBuilder().addNumberCondition(clauseName, Operator.GREATER_THAN_EQUALS, value).buildClause() : JqlQueryBuilder.newClauseBuilder().addNumberCondition(clauseName, Operator.LESS_THAN_EQUALS, value).buildClause();
        if (WORK_RATIO_ELEMENT_NAME.equals(xmlFieldId)) {
            return new ClauseXmlHandler.FullConversionResult(clause);
        }
        return new ClauseXmlHandler.BestGuessConversionResult(clause, xmlFieldId, clauseName);
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return false;
    }
}

