/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import electric.xml.Element;

public interface ClauseXmlHandler {
    public ConversionResult convertXmlToClause(Element var1);

    public boolean isSafeToNamifyValue();

    public static enum ConversionResultType {
        FULL_CONVERSION,
        BEST_GUESS_CONVERSION,
        FAILED_CONVERSION,
        NOOP_CONVERSION;

    }

    public static class BestGuessConversionResult
    implements ConversionResult {
        private final Clause clause;
        private final String oldXmlFieldName;
        private final String convertedClauseName;
        FieldManager fieldManager;

        public BestGuessConversionResult(Clause clause, String oldXmlFieldName, String convertedClauseName) {
            this.clause = (Clause)Assertions.notNull((String)"clause", (Object)clause);
            this.convertedClauseName = (String)Assertions.notNull((String)"convertedClauseName", (Object)convertedClauseName);
            this.oldXmlFieldName = (String)Assertions.notNull((String)"oldXmlFieldName", (Object)oldXmlFieldName);
        }

        @Override
        public Clause getClause() {
            return this.clause;
        }

        @Override
        public ConversionResultType getResultType() {
            return ConversionResultType.BEST_GUESS_CONVERSION;
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            String fieldName = this.getFieldNameForId(i18nHelper, this.oldXmlFieldName);
            return i18nHelper.getText("jira.jql.upgrade.best.guess.converting.to.jql", savedFilterName, fieldName, this.convertedClauseName);
        }

        String getFieldNameForId(I18nHelper i18nHelper, String oldXmlFieldName) {
            FieldManager fieldManager = this.getFieldManager();
            Field field = fieldManager.getField(oldXmlFieldName);
            if (field == null) {
                return oldXmlFieldName;
            }
            return i18nHelper.getText(field.getNameKey());
        }

        FieldManager getFieldManager() {
            if (this.fieldManager == null) {
                this.fieldManager = (FieldManager)ComponentAccessor.getComponentOfType(FieldManager.class);
            }
            return this.fieldManager;
        }

        public void setFieldManager(FieldManager fieldManager) {
            this.fieldManager = fieldManager;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BestGuessConversionResult that = (BestGuessConversionResult)o;
            if (!this.clause.equals(that.clause)) {
                return false;
            }
            if (!this.convertedClauseName.equals(that.convertedClauseName)) {
                return false;
            }
            if (this.fieldManager != null ? !this.fieldManager.equals(that.fieldManager) : that.fieldManager != null) {
                return false;
            }
            return this.oldXmlFieldName.equals(that.oldXmlFieldName);
        }

        public int hashCode() {
            int result = this.clause.hashCode();
            result = 31 * result + this.oldXmlFieldName.hashCode();
            result = 31 * result + this.convertedClauseName.hashCode();
            result = 31 * result + (this.fieldManager != null ? this.fieldManager.hashCode() : 0);
            return result;
        }
    }

    public static class FailedConversionNoValuesResult
    implements ConversionResult {
        private final String oldXmlFieldName;

        public FailedConversionNoValuesResult(String oldXmlFieldName) {
            this.oldXmlFieldName = (String)Assertions.notNull((String)"oldXmlFieldName", (Object)oldXmlFieldName);
        }

        @Override
        public Clause getClause() {
            return null;
        }

        @Override
        public ConversionResultType getResultType() {
            return ConversionResultType.FAILED_CONVERSION;
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            return i18nHelper.getText("jira.jql.upgrade.error.converting.to.jql.no.values", savedFilterName, this.oldXmlFieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedConversionNoValuesResult that = (FailedConversionNoValuesResult)o;
            return this.oldXmlFieldName.equals(that.oldXmlFieldName);
        }

        public int hashCode() {
            return this.oldXmlFieldName.hashCode();
        }
    }

    public static class FailedConversionResult
    implements ConversionResult {
        private final String oldXmlFieldName;

        public FailedConversionResult(String oldXmlFieldName) {
            this.oldXmlFieldName = (String)Assertions.notNull((String)"oldXmlFieldName", (Object)oldXmlFieldName);
        }

        @Override
        public Clause getClause() {
            return null;
        }

        @Override
        public ConversionResultType getResultType() {
            return ConversionResultType.FAILED_CONVERSION;
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            return i18nHelper.getText("jira.jql.upgrade.error.converting.to.jql", savedFilterName, this.oldXmlFieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedConversionResult that = (FailedConversionResult)o;
            return this.oldXmlFieldName.equals(that.oldXmlFieldName);
        }

        public int hashCode() {
            return this.oldXmlFieldName.hashCode();
        }
    }

    public static class NoOpConversionResult
    implements ConversionResult {
        @Override
        public Clause getClause() {
            return null;
        }

        @Override
        public ConversionResultType getResultType() {
            return ConversionResultType.NOOP_CONVERSION;
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            return null;
        }
    }

    public static class FullConversionResult
    implements ConversionResult {
        private final Clause clause;

        public FullConversionResult(Clause clause) {
            this.clause = clause;
        }

        @Override
        public Clause getClause() {
            return this.clause;
        }

        @Override
        public ConversionResultType getResultType() {
            return ConversionResultType.FULL_CONVERSION;
        }

        @Override
        public String getMessage(I18nHelper i18nHelper, String savedFilterName) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FullConversionResult that = (FullConversionResult)o;
            return this.clause.equals(that.clause);
        }

        public int hashCode() {
            return this.clause.hashCode();
        }
    }

    public static interface ConversionResult {
        public Clause getClause();

        public ConversionResultType getResultType();

        public String getMessage(I18nHelper var1, String var2);
    }
}

