/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build754
extends AbstractUpgradeTask {
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build754.class);
    private final OfBizDelegator delegator;

    public UpgradeTask_Build754(OfBizDelegator delegator) {
        super(true);
        this.delegator = delegator;
    }

    @Override
    public String getBuildNumber() {
        return "754";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        List requests = this.delegator.findAll("SearchRequest");
        if (requests == null || requests.isEmpty()) {
            return;
        }
        LOG.info((Object)String.format("Analysing %d Search Requests...", requests.size()));
        for (GenericValue gv : requests) {
            boolean store = UpgradeTask_Build754.fixUserColumn(gv, "user") | UpgradeTask_Build754.fixUserColumn(gv, "author");
            if (!store) continue;
            this.delegator.store(gv);
        }
    }

    private static boolean fixUserColumn(GenericValue gv, String columnName) {
        String lowercase_username;
        String username = gv.getString(columnName);
        if (StringUtils.isNotEmpty((String)username) && !username.equals(lowercase_username = IdentifierUtils.toLowerCase((String)username))) {
            gv.setString(columnName, lowercase_username);
            return true;
        }
        return false;
    }

    @Override
    public String getShortDescription() {
        return "Make the owner and author of a filter lowercase";
    }

    private static final class Column {
        private static final String AUTHOR = "author";
        private static final String USER = "user";

        private Column() {
        }
    }

    private static final class Table {
        static final String NAME = "SearchRequest";

        private Table() {
        }
    }
}

