/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build707
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build707.class);
    public static final String JIRA_OPTION_TRACKBACK_RECEIVE = "jira.option.trackback.receive";
    public static final String RELATIONSHIP = "Trackbacks";
    public static final String APPLICATION_TYPE = "legacy-trackbacks";
    public static final String GLOBAL_ID_PREFIX = "com.atlassian.jira:legacy-trackbacks-";
    public static final String TRACKBACK_ENTITY_NAME = "TrackbackPing";
    private IncomingTrackbacks incomingTrackbacks;

    public UpgradeTask_Build707(ApplicationPropertiesStore applicationPropertiesStore) {
        super(false);
        this.incomingTrackbacks = new IncomingTrackbacks(applicationPropertiesStore);
    }

    @Override
    public String getShortDescription() {
        return "Copying all trackbacks into remote issue links";
    }

    @Override
    public String getBuildNumber() {
        return "707";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        if (!this.incomingTrackbacks.setting().wasOn()) {
            log.info((Object)"Trackbacks disabled so not trying to convert to remote issue links.");
            return;
        }
        OfBizDelegator delegator = UpgradeTask_Build707.getOfBizDelegator();
        OfBizListIterator trackbackIterator = null;
        try {
            long currentIndex = 0L;
            trackbackIterator = delegator.findListIteratorByCondition(TRACKBACK_ENTITY_NAME, null);
            GenericValue trackback = trackbackIterator.next();
            while (trackback != null) {
                Long trackbackId = trackback.getLong("id");
                log.debug((Object)("Converting trackback: " + trackbackId.toString()));
                MapBuilder builder = MapBuilder.newBuilder();
                builder.add((Object)"issueid", (Object)trackback.getLong("issue"));
                builder.add((Object)"globalid", (Object)(GLOBAL_ID_PREFIX + trackbackId.toString()));
                builder.add((Object)"title", (Object)trackback.getString("title"));
                builder.add((Object)"summary", (Object)trackback.getString("excerpt"));
                String url = trackback.getString("url");
                builder.add((Object)"url", (Object)url);
                builder.add((Object)"relationship", (Object)RELATIONSHIP);
                builder.add((Object)"applicationtype", (Object)APPLICATION_TYPE);
                builder.add((Object)"applicationname", (Object)trackback.getString("blogname"));
                if (this.isValidUrl(url)) {
                    log.debug((Object)"Trackback url is valid, creating remote issue link");
                    delegator.createValue("RemoteIssueLink", builder.toMap());
                } else {
                    log.warn((Object)("Could not convert url string into URI. Skipping trackback. trackbackId:'" + trackbackId + "' url:'" + url + "'"));
                }
                if (++currentIndex % 1000L == 0L) {
                    log.info((Object)("Converted " + currentIndex + " trackbacks."));
                }
                trackback = trackbackIterator.next();
            }
        }
        finally {
            if (trackbackIterator != null) {
                trackbackIterator.close();
            }
        }
    }

    private boolean isValidUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            return true;
        }
        try {
            URI uri = new URI(url);
            if (!"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
                return false;
            }
            if (uri.getHost() == null) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private static class IncomingTrackbacks {
        private final ApplicationPropertiesStore applicationPropertiesStore;
        private final Setting setting;

        private IncomingTrackbacks(ApplicationPropertiesStore applicationPropertiesStore) {
            this.applicationPropertiesStore = applicationPropertiesStore;
            this.setting = new Setting();
        }

        public Setting setting() {
            return this.setting;
        }

        private class Setting {
            private Setting() {
            }

            public boolean wasOn() {
                if (IncomingTrackbacks.this.applicationPropertiesStore.existsInDb(UpgradeTask_Build707.JIRA_OPTION_TRACKBACK_RECEIVE)) {
                    return IncomingTrackbacks.this.applicationPropertiesStore.getOption(UpgradeTask_Build707.JIRA_OPTION_TRACKBACK_RECEIVE);
                }
                return Boolean.valueOf(StringUtils.defaultIfEmpty((String)IncomingTrackbacks.this.applicationPropertiesStore.getOverlayedString(UpgradeTask_Build707.JIRA_OPTION_TRACKBACK_RECEIVE), (String)"true"));
            }
        }
    }
}

