/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.FindMixedCaseUsernames;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeTask_Build6047
extends AbstractUpgradeTask {
    private static final Logger LOG = Logger.getLogger(UpgradeTask_Build6047.class);
    static final String OAUTH_SP_TOKEN_ENTITY = "OAuthServiceProviderToken";
    static final String USERNAME = "username";
    private final EntityEngine entityEngine;

    public UpgradeTask_Build6047(EntityEngine entityEngine) {
        super(false);
        this.entityEngine = entityEngine;
    }

    @Override
    public String getBuildNumber() {
        return "6047";
    }

    @Override
    public String getShortDescription() {
        return "Convert usernames to lowercase in oauthsptoken table.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        Select.SelectColumnsFromContext<String> fieldQuery = Select.distinctString(USERNAME).from(OAUTH_SP_TOKEN_ENTITY);
        Map<String, String> usernameMap = this.entityEngine.run(fieldQuery).consumeWith(FindMixedCaseUsernames.fromStrings());
        if (usernameMap.isEmpty()) {
            return;
        }
        LOG.info((Object)String.format("Analysing %d OAuthServiceProviderTokens...", usernameMap.size()));
        for (Map.Entry<String, String> entry : usernameMap.entrySet()) {
            this.entityEngine.execute(Update.into(OAUTH_SP_TOKEN_ENTITY).set(USERNAME, entry.getValue()).whereEqual(USERNAME, entry.getKey()));
        }
    }
}

