/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.upgrade.tasks.util.FindMixedCaseUsernames;
import com.atlassian.jira.util.Visitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6039
extends AbstractUpgradeTask {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final String CF_TYPE_USER_PICKER = "com.atlassian.jira.plugin.system.customfieldtypes:userpicker";
    private static final String CF_TYPE_MULTI_USER_PICKER = "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker";
    private final EntityEngine entityEngine;
    private final boolean debug;
    private boolean needReindex = false;

    public UpgradeTask_Build6039(EntityEngine entityEngine) {
        super(false);
        this.entityEngine = entityEngine;
        this.debug = this.log.isDebugEnabled();
    }

    @Override
    public String getBuildNumber() {
        return "6039";
    }

    @Override
    public boolean isReindexRequired() {
        return this.needReindex;
    }

    @Override
    public String getShortDescription() {
        return "Convert username references to lowercase so that they can be used as keys";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.log.info((Object)"Updating username references in issue fields ...");
        this.updateSimpleColumn("Issue", "assignee", true);
        this.updateSimpleColumn("Issue", "reporter", true);
        this.updateCustomFieldValuesForType(CF_TYPE_USER_PICKER);
        this.updateCustomFieldValuesForType(CF_TYPE_MULTI_USER_PICKER);
        this.log.info((Object)"Updating username references in comment authors ...");
        this.updateSimpleColumn("Action", "author", true);
        this.updateSimpleColumn("Action", "updateauthor", true);
        this.log.info((Object)"Updating username references in ownership relations (searches, favourites, etc.) ...");
        this.updateSimpleColumn("ColumnLayout", "username");
        this.updateSimpleColumn("Component", "lead");
        this.updateSimpleColumn("PortalPage", "username", true);
        this.updateSimpleColumn("Project", "lead");
        this.updateSimpleColumn("SearchRequest", "author", true);
        this.updateSimpleColumn("SearchRequest", "user", true);
        this.updateSimpleColumn("FavouriteAssociations", "username");
        this.updateSimpleColumn("UserAssociation", "sourceName", true);
        this.updateSimpleColumn("UserHistoryItem", "username");
        this.updateUserHistoryItemEntityId();
        this.doWorklogUpgrade();
    }

    protected void doWorklogUpgrade() {
        this.log.info((Object)"Updating username references in worklogs ...");
        this.updateSimpleColumn("Worklog", "author");
        this.updateSimpleColumn("Worklog", "updateauthor");
    }

    private void debugUserUpdate(Map.Entry<String, String> entry) {
        if (this.debug) {
            this.log.debug((Object)("    " + entry.getKey() + " -> " + entry.getValue()));
        }
    }

    private void updateSimpleColumn(String entityName, String fieldName) {
        this.updateSimpleColumn(entityName, fieldName, false);
    }

    private void updateSimpleColumn(String entityName, String fieldName, boolean triggersReindex) {
        Select.SelectColumnsFromContext<String> selectQuery;
        Map<String, String> usernameMap;
        if (this.debug) {
            this.log.debug((Object)("  updateSimpleColumn(" + entityName + '.' + fieldName + ')'));
        }
        if ((usernameMap = this.toUsernameMap(selectQuery = this.isMSSQL() ? Select.stringColumn(fieldName).from(entityName) : Select.distinctString(fieldName).from(entityName))).isEmpty()) {
            return;
        }
        if (triggersReindex) {
            this.needReindex = true;
        }
        for (Map.Entry<String, String> entry : usernameMap.entrySet()) {
            this.debugUserUpdate(entry);
            this.updateNamesToLowercase(entityName, fieldName, entry.getKey(), entry.getValue());
        }
    }

    private void updateNamesToLowercase(String entityName, String fieldName, String mixedName, String loweredName) {
        try {
            this.entityEngine.execute(Update.into(entityName).set(fieldName, loweredName).whereEqual(fieldName, mixedName));
        }
        catch (DataAccessException dae) {
            if ("UserHistoryItem".equals(entityName)) {
                this.entityEngine.delete(Delete.from(entityName).whereEqual(fieldName, mixedName));
            }
            if ("UserAssociation".equals(entityName)) {
                Select.WhereContext<GenericValue> allRowsForUser = Select.columns("sourceName", "sinkNodeId", "sinkNodeEntity", "associationType").from(entityName).whereEqual("sourceName", mixedName);
                this.entityEngine.run(allRowsForUser).visitWith(new AssociationVisitor(this.entityEngine, loweredName));
            }
            if ("FavouriteAssociations".equals(entityName)) {
                Select.WhereContext<GenericValue> allRowsForUser = Select.columns("id", "username", "entityType", "entityId").from(entityName).whereEqual("username", mixedName);
                this.entityEngine.run(allRowsForUser).visitWith(new FavouriteVisitor(this.entityEngine, loweredName));
            }
            throw dae;
        }
    }

    private void updateUserHistoryItemEntityId() {
        if (this.debug) {
            this.log.debug((Object)"  updateUserHistoryItemEntityId");
        }
        Select.WhereContext<String> selectQuery = this.isMSSQL() ? Select.stringColumn("entityId").from("UserHistoryItem").whereEqual("type", "UsedUser") : Select.distinctString("entityId").from("UserHistoryItem").whereEqual("type", "UsedUser");
        for (Map.Entry<String, String> entry : this.toUsernameMap(selectQuery).entrySet()) {
            this.debugUserUpdate(entry);
            try {
                this.entityEngine.execute(Update.into("UserHistoryItem").set("entityId", entry.getValue()).whereEqual("type", "UsedUser").andEqual("entityId", entry.getKey()));
            }
            catch (DataAccessException dae) {
                this.entityEngine.delete(Delete.from("UserHistoryItem").whereEqual("entityId", entry.getKey()));
            }
        }
    }

    private void updateCustomFieldValuesForType(String customFieldTypeKey) {
        if (this.debug) {
            this.log.debug((Object)("  Updating custom field values of type '" + customFieldTypeKey + '\''));
        }
        Select.WhereContext<GenericValue> selectQuery = Select.columns("id").from("CustomField").whereEqual("customfieldtypekey", customFieldTypeKey);
        Collection<Long> ids = this.entityEngine.run(selectQuery).consumeWith(new IdCollector());
        for (Long customFieldId : ids) {
            this.updateCustomField(customFieldId);
        }
    }

    private void updateCustomField(Long customFieldId) {
        Select.WhereContext<String> selectQuery;
        Map<String, String> usernameMap;
        if (this.debug) {
            this.log.debug((Object)("   updateCustomField(" + customFieldId + ')'));
        }
        if ((usernameMap = this.toUsernameMap(selectQuery = this.isMSSQL() ? Select.stringColumn("stringvalue").from("CustomFieldValue").whereEqual("customfield", customFieldId) : Select.distinctString("stringvalue").from("CustomFieldValue").whereEqual("customfield", customFieldId))).isEmpty()) {
            return;
        }
        this.needReindex = true;
        for (Map.Entry<String, String> entry : usernameMap.entrySet()) {
            this.debugUserUpdate(entry);
            this.entityEngine.execute(Update.into("CustomFieldValue").set("stringvalue", entry.getValue()).whereEqual("customfield", customFieldId).andEqual("stringvalue", entry.getKey()));
        }
    }

    protected Map<String, String> toUsernameMap(SelectQuery<String> selectQuery) {
        return this.entityEngine.run(selectQuery).consumeWith(FindMixedCaseUsernames.fromStrings());
    }

    private boolean isMSSQL() {
        return this.getDatabaseType().getFieldTypeName().startsWith("mssql");
    }

    private class IdCollector
    implements EntityListConsumer<GenericValue, Collection<Long>> {
        private final Set<Long> ids = new HashSet<Long>();

        private IdCollector() {
        }

        @Override
        public void consume(GenericValue entity) {
            this.ids.add(entity.getLong("id"));
        }

        @Override
        public Collection<Long> result() {
            return this.ids;
        }
    }

    private static class FavouriteVisitor
    implements Visitor<GenericValue> {
        private final EntityEngine entityEngine;
        private String loweredName;

        public FavouriteVisitor(EntityEngine entityEngine, String loweredName) {
            this.entityEngine = entityEngine;
            this.loweredName = loweredName;
        }

        public void visit(GenericValue element) {
            if (this.loweredName.equals(element.getString("username"))) {
                return;
            }
            Select.WhereContext lowercasedVersionExistsQuery = Select.columns("id").from("FavouriteAssociations").whereEqual("username", this.loweredName).andEqual("entityType", element.getString("entityType")).andEqual("entityId", element.getLong("entityId"));
            if (this.entityEngine.run(lowercasedVersionExistsQuery).asList().isEmpty()) {
                this.entityEngine.execute(Update.into("FavouriteAssociations").set("username", this.loweredName).whereIdEquals(element.getLong("id")));
            } else {
                this.entityEngine.delete(Delete.from("FavouriteAssociations").whereIdEquals(element.getLong("id")));
            }
        }
    }

    private static class AssociationVisitor
    implements Visitor<GenericValue> {
        private final EntityEngine entityEngine;
        private String loweredName;

        public AssociationVisitor(EntityEngine entityEngine, String loweredName) {
            this.entityEngine = entityEngine;
            this.loweredName = loweredName;
        }

        public void visit(GenericValue element) {
            if (this.loweredName.equals(element.getString("sourceName"))) {
                return;
            }
            if (this.lowercasedVersionExists(element)) {
                this.deleteThisRow(element);
            } else {
                this.lowercaseThisRow(element);
            }
        }

        private boolean lowercasedVersionExists(GenericValue element) {
            Select.WhereContext lowercasedVersionQuery = Select.columns("sinkNodeId").from("UserAssociation").whereEqual("sourceName", this.loweredName).andEqual("sinkNodeId", element.getLong("sinkNodeId")).andEqual("sinkNodeEntity", element.getString("sinkNodeEntity")).andEqual("associationType", element.getString("associationType"));
            return !this.entityEngine.run(lowercasedVersionQuery).asList().isEmpty();
        }

        private void deleteThisRow(GenericValue element) {
            Delete.DeleteWhereContext delete = Delete.from("UserAssociation").whereEqual("sourceName", element.getString("sourceName")).andEqual("sinkNodeId", element.getLong("sinkNodeId")).andEqual("sinkNodeEntity", element.getString("sinkNodeEntity")).andEqual("associationType", element.getString("associationType"));
            this.entityEngine.delete(delete);
        }

        private void lowercaseThisRow(GenericValue element) {
            Update.WhereContext lowercase = Update.into("UserAssociation").set("sourceName", this.loweredName).whereEqual("sourceName", element.getString("sourceName")).andEqual("sinkNodeId", element.getLong("sinkNodeId")).andEqual("sinkNodeEntity", element.getString("sinkNodeEntity")).andEqual("associationType", element.getString("associationType"));
            this.entityEngine.execute(lowercase);
        }
    }
}

