/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build325
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build325.class);
    private static final String DASHBOARD_ORIG_NAME = "dashboard";
    private static final String PORTAL_PAGE_ENTITY = "PortalPage";
    private static final String USERNAME_COLUMN = "username";
    private static final String ID_COLUMN = "id";
    private static final String SEQUENCE_COLUMN = "sequence";
    private final GenericDelegator delegator;
    private final PortalPageManager portalPageManager;
    private final FavouritesStore favouritesStore;
    private final I18nHelper.BeanFactory i18n;

    public UpgradeTask_Build325(GenericDelegator delegator, FavouritesStore favouritesStore, PortalPageManager portalPageManager, I18nHelper.BeanFactory i18n) {
        super(false);
        this.delegator = delegator;
        this.favouritesStore = favouritesStore;
        this.portalPageManager = portalPageManager;
        this.i18n = i18n;
    }

    @Override
    public String getBuildNumber() {
        return "325";
    }

    @Override
    public String getShortDescription() {
        return "Initialise favourite dashboards - make each dashboard a favourite of its owner.";
    }

    @Override
    public void doUpgrade(boolean setupMode) {
        this.upgradeToFavourites();
        this.upgradeSystemDefaultDashboardPage();
    }

    private void upgradeToFavourites() {
        List pageList;
        try {
            pageList = this.delegator.findByCondition(PORTAL_PAGE_ENTITY, (EntityCondition)new EntityExpr(USERNAME_COLUMN, EntityOperator.NOT_EQUAL, null), (Collection)EasyList.build((Object)ID_COLUMN, (Object)USERNAME_COLUMN), EasyList.build((Object)USERNAME_COLUMN, (Object)SEQUENCE_COLUMN, (Object)ID_COLUMN));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving dashboards.", (Throwable)e);
        }
        for (GenericValue portalPageGV : pageList) {
            Long id = null;
            String userKey = null;
            try {
                id = portalPageGV.getLong(ID_COLUMN);
                userKey = portalPageGV.getString(USERNAME_COLUMN);
                if (userKey == null) continue;
                Locale locale = this.getUserLocale(userKey);
                PortalPage portalPage = this.getPortalPage(id);
                if (portalPage != null) {
                    portalPage = this.changeDashboardName(locale, portalPage);
                    this.addAsFavourite(userKey, portalPage);
                    continue;
                }
                log.info((Object)("Could not retrieve dashboard with id '" + id + "'"));
            }
            catch (GenericEntityException e) {
                log.info((Object)("Could not find owner '" + userKey + "' for dashboard with id '" + id + "'"));
            }
            catch (DataAccessException dae) {
                String errMsg = "Error occurred while getting request or adding favourite for user '" + userKey + "' for dashboard '" + id + "'";
                if (log.isDebugEnabled()) {
                    log.debug((Object)errMsg, (Throwable)dae);
                    continue;
                }
                log.info((Object)errMsg);
            }
        }
    }

    Locale getUserLocale(String userKey) throws GenericEntityException {
        UserDetailBean userDetails = null;
        userDetails = new UserDetailBean(userKey);
        return userDetails.getLocale();
    }

    private PortalPage changeDashboardName(Locale locale, PortalPage portalPage) {
        if (DASHBOARD_ORIG_NAME.equals(portalPage.getName())) {
            I18nHelper helper = this.createI18nHelper(locale);
            String portalPageName = helper.getText("common.concepts.dashboard");
            if (StringUtils.isBlank((String)portalPageName)) {
                portalPageName = "Dashboard";
            }
            portalPage = this.portalPageManager.update(PortalPage.portalPage((PortalPage)portalPage).name(portalPageName).build());
        }
        return portalPage;
    }

    private void upgradeSystemDefaultDashboardPage() {
        try {
            PortalPage systemDefaultPage = this.portalPageManager.getSystemDefaultPortalPage();
            PortalPage updatedPage = PortalPage.portalPage((PortalPage)systemDefaultPage).name("System Dashboard").permissions(SharedEntity.SharePermissions.GLOBAL).build();
            updatedPage = this.portalPageManager.update(updatedPage);
            this.portalPageManager.adjustFavouriteCount((SharedEntity)updatedPage, 0);
        }
        catch (DataAccessException dae) {
            String errMsg = "Error occurred while updating system default dashboard!";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while updating system default dashboard!", (Throwable)dae);
            }
            log.info((Object)"Error occurred while updating system default dashboard!");
        }
    }

    I18nHelper createI18nHelper(Locale locale) {
        return this.i18n.getInstance(locale);
    }

    private PortalPage getPortalPage(Long portalPageId) {
        return this.portalPageManager.getPortalPageById(portalPageId);
    }

    private void addAsFavourite(String userKey, PortalPage portalPage) {
        this.favouritesStore.addFavourite(ComponentAccessor.getUserManager().getUserByKey(userKey), (SharedEntity)portalPage);
        this.portalPageManager.adjustFavouriteCount((SharedEntity)portalPage, 1);
    }

    private class UserDetailBean {
        private String email;
        private String fullName;
        private Locale locale;

        UserDetailBean(String username) throws GenericEntityException {
            if (!this.getUserDetail(username, "OSUser") && !this.getUserDetail(username, "ExternalEntity")) {
                throw new GenericEntityException("User not found");
            }
        }

        private boolean getUserDetail(String username, String userEntityType) {
            List OSUserGVs = null;
            OSUserGVs = UpgradeTask_Build325.getOfBizDelegator().findByAnd(userEntityType, EasyMap.build((Object)"name", (Object)username), EasyList.build((Object)"name ASC"));
            if (OSUserGVs.size() == 0) {
                return false;
            }
            GenericValue osUser = (GenericValue)OSUserGVs.iterator().next();
            PropertySet ofbizPs = OFBizPropertyUtils.getPropertySet(osUser);
            this.email = ofbizPs.getString("email");
            this.fullName = ofbizPs.getString("fullName");
            String localeStr = ofbizPs.getString("jira.user.locale");
            this.locale = StringUtils.isBlank((String)localeStr) ? ComponentAccessor.getApplicationProperties().getDefaultLocale() : LocaleParser.parseLocale((String)localeStr);
            return true;
        }

        public String getEmail() {
            return this.email;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

