/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.JiraUtilsBean;
import com.opensymphony.util.TextUtils;

public class UpgradeTask_Build152
extends AbstractUpgradeTask {
    private final ApplicationProperties applicationProperties;
    private final JiraUtilsBean jiraUtilsBean;

    public UpgradeTask_Build152(ApplicationProperties applicationProperties, JiraUtilsBean jiraUtilsBean) {
        super(false);
        this.applicationProperties = applicationProperties;
        this.jiraUtilsBean = jiraUtilsBean;
    }

    @Override
    public String getBuildNumber() {
        return "152";
    }

    @Override
    public String getShortDescription() {
        return "Set application property for visibility level of announcement banner";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        String alertHeader = this.applicationProperties.getDefaultBackedText("jira.alertheader");
        if (TextUtils.stringSet((String)alertHeader)) {
            if (this.jiraUtilsBean.isPublicMode()) {
                this.applicationProperties.setString("jira.alertheader.visibility", "public");
            } else {
                this.applicationProperties.setString("jira.alertheader.visibility", "private");
            }
        }
    }
}

