/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.studio;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.studio.StudioHooks;
import com.atlassian.jira.plugin.studio.StudioLicenseHooks;
import com.atlassian.jira.studio.VanillaStudioHooks;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class PluginStudioHooks
implements StudioHooks {
    private final Cache cache;

    public PluginStudioHooks(PluginAccessor accessor, EventPublisher publisher) {
        this.cache = new Cache(accessor);
        publisher.register((Object)this.cache);
    }

    @Override
    @Nonnull
    public StudioLicenseHooks getLicenseHooks() {
        return this.cache.get().getLicenseHooks();
    }

    public static class Cache {
        private final PluginAccessor accessor;
        private final ResettableLazyReference<StudioHooks> ref = new ResettableLazyReference<StudioHooks>(){

            protected StudioHooks create() throws Exception {
                Iterator hooksIterator = Cache.this.accessor.getEnabledModulesByClass(StudioHooks.class).iterator();
                if (!hooksIterator.hasNext()) {
                    return VanillaStudioHooks.getInstance();
                }
                StudioHooks hooks = (StudioHooks)hooksIterator.next();
                if (!hooksIterator.hasNext()) {
                    return hooks;
                }
                throw new IllegalStateException("Found more than one 'StudioHooks' implementation. We currently only support 0..1.");
            }
        };

        public Cache(PluginAccessor accessor) {
            this.accessor = accessor;
        }

        @EventListener
        public void onModuleEnabled(PluginModuleEnabledEvent event) {
            if (this.isEventRelevant(event.getModule())) {
                this.ref.reset();
            }
        }

        @EventListener
        public void onModuleDisabled(PluginModuleDisabledEvent event) {
            if (this.isEventRelevant(event.getModule())) {
                this.ref.reset();
            }
        }

        @EventListener
        public void clearCache(ClearCacheEvent event) {
            this.ref.reset();
        }

        StudioHooks get() {
            try {
                return (StudioHooks)this.ref.get();
            }
            catch (LazyReference.InitializationException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        private boolean isEventRelevant(ModuleDescriptor<?> module) {
            Class moduleClass = module.getModuleClass();
            return moduleClass != null && StudioHooks.class.isAssignableFrom(moduleClass);
        }
    }
}

