/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soap.axis;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.rpc.SoapModuleDescriptor;
import com.atlassian.jira.soap.axis.JiraAxisSoapService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.log4j.Logger;

public class JiraAxisServerFactory
extends DefaultAxisServerFactory {
    private static final Logger log = Logger.getLogger(JiraAxisServerFactory.class);

    public AxisServer getServer(Map environment) throws AxisFault {
        EngineConfiguration defaultConfig = null;
        if (environment != null) {
            try {
                defaultConfig = (EngineConfiguration)environment.get("engineConfig");
            }
            catch (ClassCastException e) {
                log.warn((Object)e, (Throwable)e);
            }
        } else {
            environment = new HashMap<String, SimpleProvider>();
        }
        SimpleProvider newConfig = new SimpleProvider(defaultConfig);
        List soapDescriptors = ComponentAccessor.getPluginAccessor().getEnabledModuleDescriptorsByClass(SoapModuleDescriptor.class);
        for (SoapModuleDescriptor soapDescriptor : soapDescriptors) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Publishing to " + soapDescriptor.getServicePath() + " module " + soapDescriptor.getModuleClass() + " with interface " + soapDescriptor.getPublishedInterface()));
                }
                JiraAxisSoapService soapService = new JiraAxisSoapService(soapDescriptor);
                newConfig.deployService(soapService.getName(), (SOAPService)soapService);
            }
            catch (Exception soapModuleDeploymentException) {
                log.error((Object)String.format("An error occurred while attempting to deploy the soap service: '%s'", soapDescriptor.getCompleteKey()), (Throwable)soapModuleDeploymentException);
            }
        }
        environment.put("engineConfig", newConfig);
        return super.getServer(environment);
    }
}

