/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.index.CompositeResultBuilder;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Indexes;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.DefaultDocumentFactory;
import com.atlassian.jira.sharing.index.DefaultQueryFactory;
import com.atlassian.jira.sharing.index.DefaultSharedEntitySearcher;
import com.atlassian.jira.sharing.index.DirectoryFactory;
import com.atlassian.jira.sharing.index.IndexSearcherFactory;
import com.atlassian.jira.sharing.index.QueryBuilder;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.index.SharedEntityDocumentFactory;
import com.atlassian.jira.sharing.index.SharedEntityFieldFactory;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.index.SharedEntitySearchContextToQueryFactoryMap;
import com.atlassian.jira.sharing.search.SharedEntitySearcher;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

public class DefaultSharedEntityIndexer
implements SharedEntityIndexer {
    private final QueryFactory queryFactory;
    private final SharedEntityAccessor.Factory accessorFactory;
    private final IndexFactory indexFactory;
    private final ReplicatedIndexManager replicatedIndexManager;
    private final EntityDocumentFactory documentFactory;
    private static final Index.Manager NULL_MANAGER = new Index.Manager(){

        @Override
        public void close() {
        }

        @Override
        public void deleteIndexDirectory() {
        }

        @Override
        public Index getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexSearcher getSearcher() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIndexCreated() {
            throw new UnsupportedOperationException();
        }
    };

    public DefaultSharedEntityIndexer(IndexPathManager indexPathManager, ShareTypeFactory shareTypeFactory, SharedEntitySearchContextToQueryFactoryMap searchContextToQueryFactoryMap, SharedEntityAccessor.Factory accessorFactory, DirectoryFactory directoryFactory, UserManager userManager, ReplicatedIndexManager replicatedIndexManager) {
        this(new DefaultQueryFactory(shareTypeFactory, searchContextToQueryFactoryMap, userManager), accessorFactory, new DefaultEntityDocumentFactory(shareTypeFactory), directoryFactory, replicatedIndexManager);
    }

    DefaultSharedEntityIndexer(QueryFactory queryFactory, SharedEntityAccessor.Factory accessorFactory, EntityDocumentFactory documentFactory, DirectoryFactory directoryFactory, ReplicatedIndexManager replicatedIndexManager) {
        this.queryFactory = (QueryFactory)Assertions.notNull((String)"queryFactory", (Object)queryFactory);
        this.accessorFactory = (SharedEntityAccessor.Factory)Assertions.notNull((String)"accessorFactory", (Object)accessorFactory);
        this.documentFactory = (EntityDocumentFactory)Assertions.notNull((String)"documentFactory", (Object)documentFactory);
        this.indexFactory = new IndexFactory(directoryFactory);
        this.replicatedIndexManager = replicatedIndexManager;
    }

    @Override
    public Index.Result index(SharedEntity entity) {
        return this.index(entity, true);
    }

    @Override
    public Index.Result deIndex(SharedEntity entity) {
        this.replicatedIndexManager.deIndexSharedEntity(entity);
        return this.indexFactory.delete(this.documentFactory.get(entity));
    }

    @Override
    public Index.Result index(SharedEntity entity, boolean updateReplicatedIndex) {
        if (updateReplicatedIndex) {
            this.replicatedIndexManager.indexSharedEntity(entity);
        }
        return this.indexFactory.update(this.documentFactory.get(entity));
    }

    @Override
    public Index.Result index(Set<SharedEntity> sharedEntities, boolean updateReplicatedIndex) {
        CompositeResultBuilder builder = new CompositeResultBuilder();
        for (SharedEntity entity : sharedEntities) {
            if (updateReplicatedIndex) {
                this.replicatedIndexManager.indexSharedEntity(entity);
            }
            builder.add(this.indexFactory.update(this.documentFactory.get(entity)));
        }
        return builder.toResult();
    }

    @Override
    public Index.Result deIndex(Set<SharedEntity> sharedEntities, boolean updateReplicatedIndex) {
        CompositeResultBuilder builder = new CompositeResultBuilder();
        for (SharedEntity entity : sharedEntities) {
            this.replicatedIndexManager.deIndexSharedEntity(entity);
            builder.add(this.indexFactory.delete(this.documentFactory.get(entity)));
        }
        return builder.toResult();
    }

    @Override
    public <S extends SharedEntity> SharedEntitySearcher<S> getSearcher(final SharedEntity.TypeDescriptor<S> type) {
        SharedEntityAccessor sharedEntityAccessor = this.accessorFactory.getSharedEntityAccessor(type);
        return new DefaultSharedEntitySearcher(new IndexSearcherFactory(){

            @Override
            public IndexSearcher get() {
                return DefaultSharedEntityIndexer.this.indexFactory.get(type, IndexFactory.Create.YES).getSearcher();
            }
        }, sharedEntityAccessor, this.queryFactory);
    }

    @Override
    public long optimize(SharedEntity.TypeDescriptor<?> type) {
        long start = System.nanoTime();
        this.indexFactory.get(type, IndexFactory.Create.YES).getIndex().perform(Operations.newOptimize()).await();
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    @Override
    public String clear(SharedEntity.TypeDescriptor<?> type) {
        this.indexFactory.get(type, IndexFactory.Create.NO).deleteIndexDirectory();
        return "todo-something here?";
    }

    @Override
    public void recreate(SharedEntity.TypeDescriptor<?> type) {
        this.indexFactory.get(type, IndexFactory.Create.YES).deleteIndexDirectory();
    }

    @Override
    public void shutdown(SharedEntity.TypeDescriptor<?> type) {
        try {
            this.indexFactory.get(type, IndexFactory.Create.NO).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Collection<String> getAllIndexPaths() {
        return Collections.emptyList();
    }

    private static final class IndexFactory {
        private final Function<SharedEntity.TypeDescriptor<?>, Directory> directoryFactory;
        private final ConcurrentMap<SharedEntity.TypeDescriptor<?>, Index.Manager> managers = new ConcurrentHashMap();

        IndexFactory(Function<SharedEntity.TypeDescriptor<?>, Directory> directoryFactory) {
            this.directoryFactory = (Function)Assertions.notNull((String)"directoryFactory", directoryFactory);
        }

        Index.Manager get(SharedEntity.TypeDescriptor<?> type, Create option) {
            Index.Manager result = (Index.Manager)this.managers.get(type);
            while (result == null && option.create()) {
                this.managers.put(type, Indexes.createQueuedIndexManager(type.getName(), new DefaultConfiguration((Directory)this.directoryFactory.get(type), QueryBuilder.Analyzers.LOWERCASE)));
                result = (Index.Manager)this.managers.get(type);
            }
            return result != null ? result : NULL_MANAGER;
        }

        Index.Result delete(EntityDocument document) {
            Index index = this.get(document.getType(), Create.YES).getIndex();
            return index.perform(Operations.newDelete(document.getIdentifyingTerm(), Index.UpdateMode.INTERACTIVE));
        }

        Index.Result update(EntityDocument document) {
            Index index = this.get(document.getType(), Create.YES).getIndex();
            return index.perform(Operations.newUpdate(document.getIdentifyingTerm(), document.getDocument(), Index.UpdateMode.INTERACTIVE));
        }

        static enum Create {
            YES(true),
            NO(false);

            private final boolean create;

            private Create(boolean create) {
                this.create = create;
            }

            boolean create() {
                return this.create;
            }
        }
    }

    static class DefaultEntityDocumentFactory
    implements EntityDocumentFactory {
        private final SharedEntityDocumentFactory documentFactory;

        DefaultEntityDocumentFactory(ShareTypeFactory shareTypeFactory) {
            this.documentFactory = this.createDocumentFactory(shareTypeFactory);
        }

        SharedEntityDocumentFactory createDocumentFactory(ShareTypeFactory shareTypeFactory) {
            return DefaultDocumentFactory.create(shareTypeFactory);
        }

        @Override
        public EntityDocument get(final SharedEntity entity) {
            return new EntityDocument(){
                private final Term identifyingTerm;
                {
                    this.identifyingTerm = new Term(SharedEntityFieldFactory.Default.ID.getFieldName(), entity.getId().toString());
                }

                @Override
                public Term getIdentifyingTerm() {
                    return this.identifyingTerm;
                }

                @Override
                public Document getDocument() {
                    return DefaultEntityDocumentFactory.this.documentFactory.create(entity);
                }

                @Override
                public SharedEntity.TypeDescriptor<?> getType() {
                    return entity.getEntityType();
                }
            };
        }
    }

    public static interface EntityDocument {
        public SharedEntity.TypeDescriptor<?> getType();

        public Term getIdentifyingTerm();

        public Document getDocument();
    }

    public static interface EntityDocumentFactory {
        public EntityDocument get(SharedEntity var1);
    }
}

