/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class CurrentReporter
extends SimpleIssueFieldSecurityType {
    public static final String DESC = "reporter";
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CurrentReporter(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.reporter");
    }

    @Override
    public String getType() {
        return DESC;
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    protected String getFieldName(String parameter) {
        return "issue_author";
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return true;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, Project project) {
        return true;
    }

    @Override
    protected String getField() {
        return DESC;
    }

    @Override
    protected String getFieldValue(Issue issue) {
        return issue.getReporterId();
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String ignored) {
        if (ctx.getIssue() != null && ctx.getIssue().getReporter() != null) {
            return Collections.singleton(ctx.getIssue().getReporter());
        }
        return Collections.emptySet();
    }
}

