/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class ProjectKeyStoreImpl
implements ProjectKeyStore {
    private static String ENTITY_NAME = "ProjectKey";
    private final OfBizDelegator ofBizDelegator;

    public ProjectKeyStoreImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Long getProjectId(String key) {
        GenericValue gv = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)"projectKey", (Object)key)));
        return gv != null ? gv.getLong("projectId") : null;
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.ofBizDelegator.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)"projectId", (Object)projectId, (Object)"projectKey", (Object)projectKey));
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        Delete.from("ProjectKey").whereEqual("projectId", projectId).execute(this.ofBizDelegator);
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        List keys = this.ofBizDelegator.findAll(ENTITY_NAME);
        if (keys == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (GenericValue key : keys) {
            result.put(key.getString("projectKey"), key.getLong("projectId"));
        }
        return result;
    }
}

