/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.comparator.ComponentComparator;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCache;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class CachingProjectManager
extends AbstractProjectManager {
    private final ProjectManager delegateProjectManager;
    private final ProjectComponentManager projectComponentManager;
    private final ProjectFactory projectFactory;
    private final ProjectCache cache;

    public CachingProjectManager(ProjectManager delegateProjectManager, ProjectComponentManager projectComponentManager, ProjectFactory projectFactory, UserManager userManager, ApplicationProperties applicationProperties, ProjectKeyStore projectKeyStore) {
        super(userManager, applicationProperties);
        this.delegateProjectManager = delegateProjectManager;
        this.projectComponentManager = projectComponentManager;
        this.projectFactory = projectFactory;
        this.cache = new ProjectCache(delegateProjectManager, projectKeyStore, true);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    public void updateCache() {
        this.cache.refresh();
    }

    public long getNextId(Project project) {
        long nextId = this.delegateProjectManager.getNextId(project);
        return nextId;
    }

    public void refresh() {
        this.updateCache();
        this.delegateProjectManager.refresh();
    }

    public GenericValue getProject(Long id) {
        return this.cache.getProject(id);
    }

    public Project getProjectObj(Long id) {
        GenericValue projectGv = this.cache.getProject(id);
        return this.genericValueToProject(projectGv);
    }

    public GenericValue getProjectByName(String name) {
        return this.cache.getProjectByName(name);
    }

    public GenericValue getProjectByKey(String key) {
        return this.cache.getProjectByKey(key);
    }

    public Project getProjectObjByKey(String projectKey) {
        GenericValue projectGv = this.getProjectByKey(projectKey);
        return this.genericValueToProject(projectGv);
    }

    @Nullable
    protected Project genericValueToProject(@Nullable GenericValue projectGv) {
        if (projectGv != null) {
            return this.projectFactory.getProject(projectGv);
        }
        return null;
    }

    @Override
    public Project getProjectByCurrentKey(String projectKey) {
        return this.genericValueToProject(this.cache.getProjectByCurrentKey(projectKey));
    }

    public Project getProjectByCurrentKeyIgnoreCase(String projectKey) {
        return this.genericValueToProject(this.cache.getProjectByCurrentKeyIgnoreCase(projectKey));
    }

    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        return this.genericValueToProject(this.cache.getProjectByKeyIgnoreCase(projectKey));
    }

    public Project getProjectObjByName(String projectName) {
        GenericValue projectGv = this.getProjectByName(projectName);
        return this.genericValueToProject(projectGv);
    }

    public GenericValue getComponent(GenericValue project, String name) {
        return this.projectComponentManager.convertToGenericValue(this.projectComponentManager.findByComponentName(project.getLong("id"), name));
    }

    public GenericValue getComponent(Long id) {
        try {
            return this.projectComponentManager.convertToGenericValue(this.projectComponentManager.find(id));
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    public Collection getComponents(GenericValue project) {
        Collection allComponentsForProject = this.projectComponentManager.findAllForProject(project.getLong("id"));
        ArrayList componentGVs = new ArrayList(this.projectComponentManager.convertToGenericValues(allComponentsForProject));
        Collections.sort(componentGVs, new ComponentComparator());
        return componentGVs;
    }

    public Collection<GenericValue> getProjects() {
        return this.noNull(this.cache.getProjects());
    }

    public List<Project> getProjectObjects() {
        List<Project> projects = this.cache.getProjectObjects();
        if (projects == null) {
            return Collections.emptyList();
        }
        return projects;
    }

    public long getProjectCount() throws DataAccessException {
        return this.getProjectObjects().size();
    }

    protected Collection noNull(Collection col) {
        if (col == null) {
            return Collections.EMPTY_LIST;
        }
        return col;
    }

    public Project createProject(String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId) {
        Project project = this.delegateProjectManager.createProject(name, key, description, lead, url, assigneeType, avatarId);
        this.updateCache();
        return project;
    }

    public Project updateProject(Project updatedProject, String name, String description, String lead, String url, Long assigneeType, Long avatarId, String projectKey) {
        Project project = this.delegateProjectManager.updateProject(updatedProject, name, description, lead, url, assigneeType, avatarId, projectKey);
        this.updateCache();
        return project;
    }

    public void removeProjectIssues(Project project) throws RemoveException {
        this.delegateProjectManager.removeProjectIssues(project);
    }

    public void removeProject(Project project) {
        this.delegateProjectManager.removeProject(project);
        this.updateCache();
    }

    public Collection<GenericValue> getProjectCategories() {
        return this.noNull(this.cache.getProjectCategories());
    }

    public Collection<ProjectCategory> getAllProjectCategories() {
        return Entity.PROJECT_CATEGORY.buildList(this.getProjectCategories());
    }

    public GenericValue getProjectCategory(Long id) {
        return this.cache.getProjectCategory(id);
    }

    public ProjectCategory getProjectCategoryObject(Long id) {
        return (ProjectCategory)Entity.PROJECT_CATEGORY.build(this.cache.getProjectCategory(id));
    }

    public void updateProjectCategory(GenericValue projectCat) {
        this.delegateProjectManager.updateProjectCategory(projectCat);
        this.updateCache();
    }

    public void updateProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        this.delegateProjectManager.updateProjectCategory(projectCategory);
        this.updateCache();
    }

    public Collection<GenericValue> getProjectsFromProjectCategory(GenericValue projectCategory) {
        return this.cache.getProjectsFromProjectCategory(projectCategory);
    }

    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        return this.getProjectObjectsFromProjectCategory(projectCategory.getId());
    }

    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        return this.projectFactory.getProjects(this.getProjectsFromProjectCategory(this.getProjectCategory(projectCategoryId)));
    }

    public GenericValue getProjectCategoryFromProject(GenericValue project) {
        return this.cache.getProjectCategoryFromProject(project);
    }

    public ProjectCategory getProjectCategoryForProject(Project project) {
        GenericValue projectCategoryForProject = this.cache.getProjectCategoryForProject(project);
        if (projectCategoryForProject != null) {
            return (ProjectCategory)Entity.PROJECT_CATEGORY.build(projectCategoryForProject);
        }
        return null;
    }

    public Collection<GenericValue> getProjectsWithNoCategory() {
        return this.cache.getProjectsWithNoCategory();
    }

    public Collection<Project> getProjectObjectsWithNoCategory() throws DataAccessException {
        return this.projectFactory.getProjects(this.getProjectsWithNoCategory());
    }

    public void setProjectCategory(GenericValue project, GenericValue category) {
        this.delegateProjectManager.setProjectCategory(project, category);
        this.updateCache();
    }

    public void setProjectCategory(Project project, ProjectCategory category) throws DataAccessException {
        this.delegateProjectManager.setProjectCategory(project, category);
        this.updateCache();
    }

    public List<Project> getProjectsLeadBy(User leadUser) {
        return this.delegateProjectManager.getProjectsLeadBy(leadUser);
    }

    public List<Project> getProjectsLeadBy(ApplicationUser leadUser) {
        return this.delegateProjectManager.getProjectsLeadBy(leadUser);
    }

    public Collection<GenericValue> getProjectsByLead(User leadUser) {
        return this.delegateProjectManager.getProjectsByLead(leadUser);
    }

    public ProjectCategory createProjectCategory(String name, String description) {
        ProjectCategory projectCategory = this.delegateProjectManager.createProjectCategory(name, description);
        this.updateCache();
        return projectCategory;
    }

    public void removeProjectCategory(Long id) {
        this.delegateProjectManager.removeProjectCategory(id);
        this.updateCache();
    }

    public long getCurrentCounterForProject(Long id) {
        return this.delegateProjectManager.getCurrentCounterForProject(id);
    }

    public void setCurrentCounterForProject(Project project, long counter) {
        this.delegateProjectManager.setCurrentCounterForProject(project, counter);
    }
}

