/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal.gadgets;

import com.atlassian.event.api.EventListener;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecId;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.portal.gadgets.ExternalGadgetStore;
import com.atlassian.jira.util.dbc.Assertions;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

@EventComponent
public class CachingExternalGadgetStore
implements ExternalGadgetStore {
    public final Map<ExternalGadgetSpecId, ExternalGadgetSpec> specCache = new ConcurrentHashMap<ExternalGadgetSpecId, ExternalGadgetSpec>();
    public final Set<URI> uriCache = new CopyOnWriteArraySet<URI>();
    private final ExternalGadgetStore delegateStore;

    public CachingExternalGadgetStore(ExternalGadgetStore delegateStore) {
        this.delegateStore = (ExternalGadgetStore)Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.init(delegateStore);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.specCache.clear();
        this.uriCache.clear();
        this.init(this.delegateStore);
    }

    @Override
    public Set<ExternalGadgetSpec> getAllGadgetSpecUris() {
        return Collections.unmodifiableSet(new HashSet<ExternalGadgetSpec>(this.specCache.values()));
    }

    @Override
    public ExternalGadgetSpec addGadgetSpecUri(URI uri) {
        ExternalGadgetSpec addedSpec = this.delegateStore.addGadgetSpecUri(uri);
        this.specCache.put(addedSpec.getId(), addedSpec);
        this.uriCache.add(addedSpec.getSpecUri());
        return addedSpec;
    }

    @Override
    public void removeGadgetSpecUri(ExternalGadgetSpecId id) {
        this.delegateStore.removeGadgetSpecUri(id);
        ExternalGadgetSpec removedSpec = this.specCache.remove(id);
        this.uriCache.remove(removedSpec.getSpecUri());
    }

    @Override
    public boolean containsSpecUri(URI uri) {
        return this.uriCache.contains(uri);
    }

    private void init(ExternalGadgetStore delegateStore) {
        Set<ExternalGadgetSpec> specs = delegateStore.getAllGadgetSpecUris();
        for (ExternalGadgetSpec spec : specs) {
            this.specCache.put(spec.getId(), spec);
            this.uriCache.add(spec.getSpecUri());
        }
    }
}

