/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.issue.EditIssue;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class UpdateIssueFieldFunctionPluginFactory
extends AbstractWorkflowPluginFactory
implements WorkflowPluginFunctionFactory {
    private static final String PARAM_NAME = "eventType";
    private final FieldManager fieldManager;
    private final UserKeyService userKeyService;
    private final List fields;
    public static final String PARAM_FIELD_ID = "fieldId";
    public static final String PARAM_FIELD_VALUE = "fieldValue";
    public static final String TARGET_FIELD_NAME = "field.name";
    public static final String TARGET_FIELD_VALUE = "field.value";
    public static final String DEFAULT_VALUE = "-1";

    public UpdateIssueFieldFunctionPluginFactory(FieldManager fieldManager, UserKeyService userKeyService) {
        this.fieldManager = fieldManager;
        this.fields = new ArrayList(9);
        this.userKeyService = userKeyService;
        this.fields.add(fieldManager.getField("assignee"));
        this.fields.add(fieldManager.getField("description"));
        this.fields.add(fieldManager.getField("environment"));
        this.fields.add(fieldManager.getField("priority"));
        this.fields.add(fieldManager.getField("resolution"));
        this.fields.add(fieldManager.getField("summary"));
        this.fields.add(fieldManager.getField("timeoriginalestimate"));
        this.fields.add(fieldManager.getField("timeestimate"));
        this.fields.add(fieldManager.getField("timespent"));
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        velocityParams.put("fields", this.fields);
        velocityParams.put("factory", this);
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String fieldName = (String)functionDescriptor.getArgs().get(TARGET_FIELD_NAME);
        velocityParams.put(PARAM_FIELD_ID, fieldName);
        String value = (String)functionDescriptor.getArgs().get(TARGET_FIELD_VALUE);
        if (value == null || value.equals("null")) {
            velocityParams.put(PARAM_FIELD_VALUE, null);
        } else {
            boolean persistedValueIsUserkey = "assignee".equals(fieldName) && !DEFAULT_VALUE.equals(value);
            String valueTranslatedForEdit = persistedValueIsUserkey ? this.userKeyService.getUsernameForKey(value) : value;
            velocityParams.put(PARAM_FIELD_VALUE, valueTranslatedForEdit);
        }
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String fieldName = (String)functionDescriptor.getArgs().get(TARGET_FIELD_NAME);
        Field field = this.fieldManager.getField(fieldName);
        velocityParams.put(PARAM_FIELD_ID, field.getNameKey());
        String fieldValue = (String)functionDescriptor.getArgs().get(TARGET_FIELD_VALUE);
        boolean persistedValueIsUserkey = "assignee".equals(fieldName) && !DEFAULT_VALUE.equals(fieldValue);
        String valueTranslatedForView = persistedValueIsUserkey ? this.userKeyService.getUsernameForKey(fieldValue) : fieldValue;
        velocityParams.put(PARAM_FIELD_VALUE, this.getViewHtml(field, valueTranslatedForView));
    }

    public Map getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        String fieldId = this.extractSingleParam(conditionParams, PARAM_FIELD_ID);
        params.put(TARGET_FIELD_NAME, fieldId);
        String fieldValue = this.extractSingleParam(conditionParams, PARAM_FIELD_VALUE);
        String valueTranslatedForPersistence = "assignee".equals(fieldId) && !DEFAULT_VALUE.equals(fieldValue) ? this.userKeyService.getKeyForUsername(fieldValue) : fieldValue;
        params.put(TARGET_FIELD_VALUE, valueTranslatedForPersistence);
        return params;
    }

    public String getEditHtml(final OrderableField field, final Object value) {
        OperationContext operationContext = new OperationContext(){

            public Map getFieldValuesHolder() {
                return EasyMap.build((Object)field.getId(), (Object)value);
            }

            public IssueOperation getIssueOperation() {
                return new IssueOperation(){

                    public String getNameKey() {
                        return "Populate Workflow Function";
                    }

                    public String getDescriptionKey() {
                        return "Select a value that should be set on an issue when this function is executed.";
                    }
                };
            }
        };
        return field.getEditHtml(null, operationContext, (Action)JiraUtils.loadComponent(EditIssue.class), null, EasyMap.build((Object)"noHeader", (Object)"true", (Object)"displayNone", (Object)"true"));
    }

    public boolean hasCustomEditTemplate(Field field) {
        return "priority".equals(field.getId()) || "assignee".equals(field.getId()) || "resolution".equals(field.getId());
    }

    private boolean hasCustomViewTemplate(Field field) {
        return this.hasCustomEditTemplate(field);
    }

    private Object getViewHtml(Field field, String fieldValue) {
        if (this.hasCustomViewTemplate(field)) {
            OrderableField orderableField = (OrderableField)field;
            String fieldId = field.getId();
            if ("priority".equals(fieldId) || "resolution".equals(fieldId)) {
                GenericValue value = (GenericValue)orderableField.getValueFromParams((Map)ImmutableMap.of((Object)fieldId, (Object)fieldValue));
                if (value != null) {
                    return value.getString("name");
                }
            } else if ("assignee".equals(fieldId) && fieldValue != null) {
                return orderableField.getValueFromParams((Map)ImmutableMap.of((Object)fieldId, (Object)fieldValue));
            }
        }
        return fieldValue;
    }
}

