/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.descriptors;

import com.atlassian.jira.plugin.webfragment.descriptors.ConditionDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class ConditionDescriptorFactoryImpl
implements ConditionDescriptorFactory,
ConditionElementParser.ConditionFactory {
    private ConditionElementParser conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)this);
    private HostContainer hostContainer;

    public ConditionDescriptorFactoryImpl(HostContainer hostContainer) {
        this.hostContainer = hostContainer;
    }

    public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            Class aCondition = plugin.loadClass(className, this.getClass());
            return (Condition)this.hostContainer.create(aCondition);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionLoadingException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Condition retrieveCondition(@Nonnull Plugin plugin, @Nonnull Element element) {
        Element conditionEl = element.element("condition");
        Element conditionsEl = element.element("conditions");
        if (conditionEl != null || conditionsEl != null) {
            if (conditionEl != null && conditionEl.attribute("class") == null) {
                throw new PluginParseException("class is a required attribute of the condition tag; plugin module: " + plugin.getKey());
            }
            if (conditionsEl != null && !conditionsEl.selectNodes("./condition[not(@class)]").isEmpty()) {
                throw new PluginParseException("class is a required attribute of the conditions tag; plugin module: " + plugin.getKey());
            }
            return this.conditionElementParser.makeConditions(plugin, element, 1);
        }
        return DEFAULT_CONDITION;
    }
}

