/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ShowDashboardToolsMenuCondition
implements Condition {
    public static final String CONTEXT_KEY_DASHBOARD_ID = "dashboardId";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        DashboardPermissionService permissionService = this.getPermissionService();
        PortalPageService portalPageService = this.getPortalPageService();
        PortalPage defaultPortalPage = portalPageService.getSystemDefaultPortalPage();
        DashboardId dashboardId = (DashboardId)context.get(CONTEXT_KEY_DASHBOARD_ID);
        String username = (String)context.get("username");
        if (dashboardId != null && defaultPortalPage.getId().equals(Long.valueOf(dashboardId.value())) && permissionService.isWritableBy(dashboardId, username)) {
            return false;
        }
        User user = this.getUserUtil().getUser(username);
        return user != null;
    }

    PortalPageService getPortalPageService() {
        return (PortalPageService)ComponentAccessor.getComponentOfType(PortalPageService.class);
    }

    DashboardPermissionService getPermissionService() {
        return (DashboardPermissionService)ComponentAccessor.getComponentOfType(DashboardPermissionService.class);
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

