/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class FooterModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<PluggableFooter>
implements FooterModuleDescriptor {
    private static final String VIEW_TEMPLATE = "view";
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private int order;

    public FooterModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, ModuleFactory moduleFactory, PermissionManager permissionManager, ApplicationProperties applicationProperties) {
        super(authenticationContext, moduleFactory);
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    @Override
    public void enabled() {
        super.enabled();
    }

    public int getOrder() {
        return this.order;
    }

    public String getFooterHtml(HttpServletRequest request, Map startingParams) {
        Map params = this.createVelocityParams(request, startingParams);
        return this.getHtml(VIEW_TEMPLATE, params);
    }

    protected Map createVelocityParams(HttpServletRequest request, Map startingParams) {
        HashMap<String, Object> params = startingParams != null ? new HashMap<String, Object>(startingParams) : new HashMap();
        String licenseMessageClass = null;
        boolean longFooterMessage = true;
        LicenseDetails licenseDetails = this.jiraLicenseService.getLicense();
        if (!licenseDetails.isLicenseSet() || licenseDetails.isEvaluation() || !licenseDetails.isCommercial() || licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            params.put("notfull", Boolean.TRUE);
            if (!licenseDetails.isLicenseSet()) {
                params.put("unlicensed", Boolean.TRUE);
                licenseMessageClass = "licensemessagered";
            } else if (licenseDetails.isEvaluation()) {
                longFooterMessage = false;
                params.put("evaluation", Boolean.TRUE);
                licenseMessageClass = "licensemessagered";
            } else if (licenseDetails.hasLicenseTooOldForBuildConfirmationBeenDone()) {
                params.put("confirmedWithOldLicense", Boolean.TRUE);
                licenseMessageClass = "licensemessagered";
            } else if (licenseDetails.isCommunity()) {
                longFooterMessage = false;
                params.put("community", Boolean.TRUE);
                licenseMessageClass = "licensemessage";
            } else if (licenseDetails.isOpenSource()) {
                longFooterMessage = false;
                params.put("opensource", Boolean.TRUE);
                licenseMessageClass = "licensemessage";
            } else if (licenseDetails.isNonProfit()) {
                longFooterMessage = false;
                params.put("nonprofit", Boolean.TRUE);
                licenseMessageClass = "licensemessage";
            } else if (licenseDetails.isDemonstration()) {
                params.put("demonstration", Boolean.TRUE);
                licenseMessageClass = "licensemessage";
            } else if (licenseDetails.isDeveloper()) {
                params.put("developer", Boolean.TRUE);
                licenseMessageClass = "licensemessage";
            } else if (licenseDetails.isPersonalLicense()) {
                licenseMessageClass = "licensemessage";
                params.put("personal", licenseDetails.isPersonalLicense());
            }
        }
        if (licenseMessageClass != null) {
            params.put("licenseMessageClass", licenseMessageClass);
        }
        params.put("organisation", licenseDetails.getOrganisation());
        params.put("longFooterMessage", longFooterMessage);
        params.put("serverid", this.jiraLicenseService.getServerId());
        params.put("externalLinkUtil", ExternalLinkUtilImpl.getInstance());
        params.put("utilTimerStack", new UtilTimerStack());
        params.put("version", this.buildUtilsInfo.getVersion());
        params.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        params.put("req", request);
        params.put("build", this.buildUtilsInfo);
        params.put("string", new StringUtils());
        params.put("isSysAdmin", this.permissionManager.hasPermission(44, this.getAuthenticationContext().getLoggedInUser()));
        params.put("showContactAdminForm", this.applicationProperties.getOption("jira.show.contact.administrators.form"));
        return params;
    }
}

