/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel3;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueTabPanelInvokerImpl
implements IssueTabPanelInvoker {
    private static final Logger log = LoggerFactory.getLogger(IssueTabPanelInvokerImpl.class);
    private final I18nHelper.BeanFactory i18Factory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueTabPanelInvokerImpl(I18nHelper.BeanFactory i18Factory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.i18Factory = i18Factory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeShowPanel(ShowPanelRequest request, IssueTabPanelModuleDescriptor descriptor) {
        String timerName = "Calling showPanel for " + descriptor;
        UtilTimerStack.push((String)timerName);
        try {
            IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
            try {
                boolean bl = issueTabPanel.showPanel(request);
                return bl;
            }
            catch (AbstractMethodError e) {
                boolean bl;
                try {
                    log.error(this.formatBinaryCompatibilityMessage(issueTabPanel, "showPanel"), (Throwable)e);
                    bl = true;
                }
                catch (RuntimeException e2) {
                    log.error("Exception thrown while trying to call showPanel() for " + descriptor, (Throwable)e2);
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                UtilTimerStack.pop((String)timerName);
                return bl;
            }
        }
        finally {
            UtilTimerStack.pop((String)timerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IssueAction> invokeGetActions(GetActionsRequest request, IssueTabPanelModuleDescriptor descriptor) {
        String timerName = "Calling getActions in" + descriptor;
        UtilTimerStack.push((String)timerName);
        try {
            IssueTabPanel3 issueTabPanel = (IssueTabPanel3)descriptor.getModule();
            try {
                List list = issueTabPanel.getActions(request);
                return list;
            }
            catch (AbstractMethodError e) {
                List<IssueAction> list;
                try {
                    log.error(this.formatBinaryCompatibilityMessage(issueTabPanel, "getActions"), (Throwable)e);
                    list = Collections.singletonList(new RenderingErrorAction(descriptor));
                }
                catch (RuntimeException e2) {
                    log.error("Exception thrown while trying to call getActions() for " + descriptor, (Throwable)e2);
                    List<IssueAction> list2 = Collections.singletonList(new RenderingErrorAction(descriptor));
                    return list2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                UtilTimerStack.pop((String)timerName);
                return list;
            }
        }
        finally {
            UtilTimerStack.pop((String)timerName);
        }
    }

    private String formatBinaryCompatibilityMessage(IssueTabPanel3 issueTabPanel, String methodName) {
        return String.format("%s does not implement IssueTabPanel.%s(com.atlassian.jira.issues.Issue, com.atlassian.crowd.embedded.api.User). This likely means the plugin is not compatible with this version of JIRA.", methodName, issueTabPanel.getClass().getName());
    }

    class RenderingErrorAction
    implements IssueAction {
        private final IssueTabPanelModuleDescriptor moduleDescriptor;

        public RenderingErrorAction(IssueTabPanelModuleDescriptor moduleDescriptor) {
            this.moduleDescriptor = moduleDescriptor;
        }

        public String getHtml() {
            return IssueTabPanelInvokerImpl.this.i18Factory.getInstance(IssueTabPanelInvokerImpl.this.jiraAuthenticationContext.getUser()).getText("modulewebcomponent.exception", this.moduleDescriptor.getCompleteKey());
        }

        public Date getTimePerformed() {
            return new java.sql.Date(System.currentTimeMillis());
        }

        public boolean isDisplayActionAllTab() {
            return true;
        }
    }
}

