/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraOsgiContainerManager
extends FelixOsgiContainerManager
implements Startable {
    private static final Logger log = LoggerFactory.getLogger(JiraOsgiContainerManager.class);
    private final Cache<String, CacheObject<ServiceTracker>> serviceTrackerCache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new ServiceTrackerRemovalListener()).build((CacheLoader)new ServiceTrackerLoader());

    public JiraOsgiContainerManager(PluginPath pluginPath, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        super(pluginPath.getOsgiPersistentCache(), packageScannerConfig, provider, eventManager);
    }

    public <T> T getOsgiComponentOfType(Class<T> clazz) {
        ServiceTracker serviceTracker;
        if (this.isRunning() && (serviceTracker = this.getServiceTrackerFromCache(clazz.getName())) != null) {
            return clazz.cast(serviceTracker.getService());
        }
        return null;
    }

    public void start() {
        new GoogleCacheInstruments(JiraOsgiContainerManager.class.getSimpleName()).addCache(this.serviceTrackerCache).install();
        super.start();
    }

    public void stop() throws OsgiContainerException {
        this.serviceTrackerCache.invalidateAll();
        super.stop();
    }

    private ServiceTracker getServiceTrackerFromCache(String className) {
        return (ServiceTracker)((CacheObject)this.serviceTrackerCache.getUnchecked((Object)className)).getValue();
    }

    private static class ServiceTrackerRemovalListener
    implements RemovalListener<String, CacheObject<ServiceTracker>> {
        private ServiceTrackerRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, CacheObject<ServiceTracker>> notification) {
            ServiceTracker serviceTracker;
            CacheObject cacheObject = (CacheObject)notification.getValue();
            if (cacheObject != null && (serviceTracker = (ServiceTracker)cacheObject.getValue()) != null) {
                log.trace("Closing service tracker: {}", (Object)serviceTracker);
                serviceTracker.close();
            }
        }
    }

    private class ServiceTrackerLoader
    extends CacheLoader<String, CacheObject<ServiceTracker>> {
        private ServiceTrackerLoader() {
        }

        public CacheObject<ServiceTracker> load(String className) throws Exception {
            ServiceTracker serviceTracker = JiraOsgiContainerManager.this.getServiceTracker(className);
            log.trace("Created service tracker for '{}': {}", (Object)className, (Object)serviceTracker);
            return CacheObject.wrap(serviceTracker);
        }
    }
}

