/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserUtil;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class GroupDropdown
extends AbstractNotificationType {
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public GroupDropdown(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String groupName) {
        ArrayList<NotificationRecipient> recipients = new ArrayList<NotificationRecipient>();
        SortedSet users = this.getUserUtil().getAllUsersInGroupNames(Arrays.asList(groupName));
        for (User user : users) {
            recipients.add(new NotificationRecipient(user));
        }
        return recipients;
    }

    private UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.group");
    }

    @Override
    public String getType() {
        return "group";
    }

    public Collection getGroups() {
        return ComponentAccessor.getUserManager().getGroups();
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        return value != null && TextUtils.stringSet((String)((String)value));
    }
}

