/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class UserMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(UserMailQueueItem.class);
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private static final Integer PADSIZE = 20;
    private final UserEvent event;
    private final String subjectKey;
    private final String template;
    private final ApplicationProperties applicationProperties;
    private final TemplateContextFactory templateContextFactory;
    private final FeatureManager featureManager;

    public UserMailQueueItem(UserEvent event, String subject, String subjectKey, String template) {
        super(subject);
        this.event = event;
        this.subjectKey = subjectKey;
        this.template = template;
        this.applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        this.templateContextFactory = (TemplateContextFactory)ComponentAccessor.getComponent(TemplateContextFactory.class);
        this.featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
    }

    public void send() throws MailException {
        this.incrementSendCount();
        try {
            User user = this.event.getUser();
            if (user != null) {
                Map<String, Object> params = this.getUserContextParamsBody(this.event);
                params.put("initiatingUser", this.event.getInitiatingUser());
                params.put("applicationName", this.getApplicationName());
                params.put("product", this.getProduct());
                I18nBean i18nBean = new I18nBean(user);
                TemplateContext templateContext = this.templateContextFactory.getTemplateContext(i18nBean.getLocale());
                params.putAll(templateContext.getTemplateParams());
                params.put("padSize", PADSIZE);
                params.put("stringUtils", new StringUtils());
                String templatePath = this.getTemplatePath(this.template);
                VelocityTemplatingEngine.RenderRequest request = this.getTemplatingEngine().render(TemplateSources.file((String)templatePath)).applying(params);
                String body = templatePath.contains("html") ? request.asHtml() : request.asPlainText();
                Email email = new Email(user.getEmailAddress());
                email.setSubject(i18nBean.getText(this.getSubjectKey()));
                email.setBody(body);
                email.setMimeType(this.getMimeType(templatePath));
                this.getMailQueue().addItem((MailQueueItem)new SingleMailQueueItem((com.atlassian.mail.Email)email));
            } else {
                log.warn((Object)("Mail with subject '" + this.getSubject() + "' not sent since user '" + user + "' no longer exists."));
            }
        }
        catch (Exception ex) {
            throw new MailException((Throwable)ex);
        }
    }

    public String getSubjectKey() {
        return this.subjectKey;
    }

    @VisibleForTesting
    MailQueue getMailQueue() {
        return ComponentAccessor.getMailQueue();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    protected Map<String, Object> getUserContextParamsBody(UserEvent uEvent) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("user", uEvent.getUser());
        contextParams.put("params", uEvent.getParams());
        return JiraMailQueueUtils.getContextParamsBody(contextParams);
    }

    private String getApplicationName() {
        return this.applicationProperties.getText("jira.title");
    }

    private String getProduct() {
        return this.featureManager.isOnDemand() ? "ondemand" : "jira";
    }

    private String getTemplatePath(String template) {
        boolean renderAsHtml = ClassLoaderUtils.getResource((String)("templates/email/html/" + template), ((Object)((Object)this)).getClass()) != null;
        String prefix = renderAsHtml ? "html/" : "text/";
        return EMAIL_TEMPLATES + prefix + template;
    }

    private String getMimeType(String template) {
        boolean renderAsHtml = template.contains("html");
        return renderAsHtml ? "text/html" : "text/plain";
    }
}

