/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class LabelsClauseValuesGenerator
implements ClauseValuesGenerator {
    private final LabelManager labelManager;

    public LabelsClauseValuesGenerator(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(User searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        TreeSet suggestions = new TreeSet();
        Collection fieldIds = this.getSearchHandlerManager().getFieldIds(searcher, jqlClauseName);
        for (String fieldId : fieldIds) {
            if (fieldId.equals(SystemSearchConstants.forLabels().getFieldId())) {
                suggestions.addAll(this.labelManager.getSuggestedLabels(searcher, null, valuePrefix));
                continue;
            }
            suggestions.addAll(this.labelManager.getSuggestedLabels(searcher, null, CustomFieldUtils.getCustomFieldId((String)fieldId), valuePrefix));
        }
        ArrayList<ClauseValuesGenerator.Result> results = new ArrayList<ClauseValuesGenerator.Result>();
        for (String suggestion : suggestions) {
            if (results.size() == maxNumResults) break;
            results.add(new ClauseValuesGenerator.Result(suggestion));
        }
        return new ClauseValuesGenerator.Results(results);
    }

    SearchHandlerManager getSearchHandlerManager() {
        return (SearchHandlerManager)ComponentAccessor.getComponentOfType(SearchHandlerManager.class);
    }
}

