/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.WatchesIndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.IndexValuesValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;

@InjectableComponent
public class WatchesValidator
implements ClauseValidator {
    private final IndexValuesValidator indexValuesValidator;
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;
    private final WatcherManager watcherManager;

    public WatchesValidator(JqlOperandResolver jqlOperandResolver, WatchesIndexValueConverter watchesIndexValueConverter, WatcherManager watcherManager) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.watcherManager = watcherManager;
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.indexValuesValidator = this.getIndexValuesValidator(watchesIndexValueConverter);
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        if (this.watcherManager.isWatchingEnabled()) {
            MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
            if (!errors.hasAnyErrors()) {
                errors = this.indexValuesValidator.validate(searcher, terminalClause);
            }
            return errors;
        }
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.watches.disabled", terminalClause.getName()));
        return messageSet;
    }

    IndexValuesValidator getIndexValuesValidator(WatchesIndexValueConverter watchesIndexValueConverter) {
        return new IndexValuesValidator(this.jqlOperandResolver, watchesIndexValueConverter, false){

            void addError(MessageSet messageSet, User searcher, TerminalClause terminalClause, QueryLiteral literal) {
                String literalString;
                String fieldName = terminalClause.getName();
                String string = literalString = literal.isEmpty() ? "EMPTY" : literal.asString();
                if (WatchesValidator.this.jqlOperandResolver.isFunctionOperand(literal.getSourceOperand())) {
                    messageSet.addErrorMessage(WatchesValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.watches.value.function", literal.getSourceOperand().getName(), fieldName));
                } else {
                    messageSet.addErrorMessage(WatchesValidator.this.getI18n(searcher).getText("jira.jql.clause.invalid.watches.value", fieldName, literalString));
                }
            }
        };
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS, OperatorClasses.RELATIONAL_ONLY_OPERATORS});
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

