/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.SavedFilterResolver;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SavedFilterCycleDetector;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class SavedFilterClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final SavedFilterResolver savedFilterResolver;
    private final JqlOperandResolver jqlOperandResolver;
    private final SavedFilterCycleDetector savedFilterCycleDetector;

    public SavedFilterClauseValidator(SavedFilterResolver savedFilterResolver, JqlOperandResolver jqlOperandResolver, SavedFilterCycleDetector savedFilterCycleDetector) {
        this.savedFilterResolver = savedFilterResolver;
        this.jqlOperandResolver = jqlOperandResolver;
        this.savedFilterCycleDetector = savedFilterCycleDetector;
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause, Long filterId) {
        Operand operand;
        List rawValues;
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!messageSet.hasAnyErrors() && (rawValues = this.jqlOperandResolver.getValues(searcher, operand = terminalClause.getOperand(), terminalClause)) != null) {
            I18nHelper i18n = this.getI18n(searcher);
            for (QueryLiteral rawValue : rawValues) {
                if (rawValue.isEmpty()) {
                    if (this.jqlOperandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                        messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty.from.func", terminalClause.getName(), rawValue.getSourceOperand().getName()));
                        continue;
                    }
                    messageSet.addErrorMessage(i18n.getText("jira.jql.clause.field.does.not.support.empty", terminalClause.getName()));
                    continue;
                }
                List<SearchRequest> matchingFilters = this.savedFilterResolver.getSearchRequest(searcher, Collections.singletonList(rawValue));
                if (matchingFilters.isEmpty()) {
                    if (rawValue.getStringValue() != null) {
                        if (this.jqlOperandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), terminalClause.getName()));
                            continue;
                        }
                        messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name", terminalClause.getName(), rawValue.toString()));
                        continue;
                    }
                    if (rawValue.getLongValue() == null) continue;
                    if (this.jqlOperandResolver.isFunctionOperand(rawValue.getSourceOperand())) {
                        messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.name.from.function", rawValue.getSourceOperand().getName(), terminalClause.getName()));
                        continue;
                    }
                    messageSet.addErrorMessage(i18n.getText("jira.jql.clause.no.value.for.id", terminalClause.getName(), rawValue.toString()));
                    continue;
                }
                for (SearchRequest matchingFilter : matchingFilters) {
                    if (!this.savedFilterCycleDetector.containsSavedFilterReference(searcher, false, matchingFilter, filterId)) continue;
                    messageSet.addErrorMessage(i18n.getText("jira.jql.saved.filter.detected.cycle", terminalClause.getName(), rawValue.toString(), matchingFilter.getName()));
                }
            }
        }
        return messageSet;
    }

    @Nonnull
    public MessageSet validate(User searcher, @Nonnull TerminalClause terminalClause) {
        return this.validate(searcher, terminalClause, null);
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS});
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

