/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlTimetrackingDurationSupport;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.NumberTools;

@InjectableComponent
public class JqlTimetrackingDurationSupportImpl
implements JqlTimetrackingDurationSupport {
    private final Function<String, Long> parser;

    public JqlTimetrackingDurationSupportImpl(JiraDurationUtils durationUtils) {
        this(new DurationUtilsParser(durationUtils));
    }

    @VisibleForTesting
    JqlTimetrackingDurationSupportImpl(Function<String, Long> parser) {
        this.parser = (Function)Assertions.notNull((String)"parser", parser);
    }

    @Override
    public boolean validate(String durationString) {
        String trimDuration = StringUtils.trimToNull((String)durationString);
        if (trimDuration != null) {
            Long value = (Long)this.parser.apply((Object)trimDuration);
            return value != null && value >= 0L;
        }
        return false;
    }

    public String convertToIndexValue(QueryLiteral rawValue) {
        Assertions.notNull((String)"rawValue", (Object)rawValue);
        if (rawValue.getLongValue() != null) {
            return this.convertToIndexValue(rawValue.getLongValue());
        }
        if (rawValue.getStringValue() != null) {
            return this.convertToIndexValue(rawValue.getStringValue());
        }
        return null;
    }

    public Long convertToDuration(Long durationInMinutes) {
        Assertions.notNull((String)"durationInMinutes", (Object)durationInMinutes);
        return this.convertToDuration(durationInMinutes.toString());
    }

    public Long convertToDuration(String durationString) {
        Assertions.notNull((String)"durationString", (Object)durationString);
        String trimDuration = StringUtils.trimToNull((String)durationString);
        if (trimDuration != null) {
            return (Long)this.parser.apply((Object)trimDuration);
        }
        return null;
    }

    protected String convertToIndexValue(Long durationInMinutes) {
        Long l = this.convertToDuration(durationInMinutes);
        if (l != null) {
            return NumberTools.longToString((long)l);
        }
        return null;
    }

    protected String convertToIndexValue(String durationString) {
        Long l;
        String trimDuration = StringUtils.trimToNull((String)durationString);
        if (trimDuration != null && (l = this.convertToDuration(trimDuration)) != null) {
            return NumberTools.longToString((long)l);
        }
        return null;
    }

    private static class DurationUtilsParser
    implements Function<String, Long> {
        private final JiraDurationUtils durationUtils;

        public DurationUtilsParser(JiraDurationUtils durationUtils) {
            this.durationUtils = durationUtils;
        }

        public Long apply(@Nullable String from) {
            try {
                return this.durationUtils.parseDuration(from, Locale.ENGLISH);
            }
            catch (InvalidDurationException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

