/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class UserResolverImpl
implements UserResolver {
    private static final Logger log = Logger.getLogger(UserResolverImpl.class);
    private final UserKeyService userKeyService;
    private final UserManager userManager;

    public UserResolverImpl(UserKeyService userKeyService, UserManager userManager) {
        this.userKeyService = userKeyService;
        this.userManager = userManager;
    }

    public List<String> getIdsFromName(String name) {
        Assertions.notNull((String)"name", (Object)name);
        ApplicationUser user = this.userManager.getUserByName(name);
        if (user != null) {
            return Collections.singletonList(user.getKey());
        }
        return this.getUsersFromFullNameOrEmail(name);
    }

    public boolean nameExists(String name) {
        Assertions.notNull((String)"name", (Object)name);
        if (this.userManager.getUserByName(name) != null) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Username '" + name + "' not found - searching as email or full name."));
        }
        return this.hasAnyFullNameOrEmailMatches(name);
    }

    public boolean idExists(Long id) {
        return this.nameExists(((Long)Assertions.notNull((String)"id", (Object)id)).toString());
    }

    private List<String> pickEmailOrFullNameMatches(String name, List<String> fullNameMatches, List<String> emailMatches) {
        if (emailMatches.isEmpty()) {
            return fullNameMatches;
        }
        if (fullNameMatches.isEmpty() || this.isEmail(name)) {
            return emailMatches;
        }
        return fullNameMatches;
    }

    private List<String> getUsersFromFullNameOrEmail(String name) {
        ArrayList<String> fullNameMatches = new ArrayList<String>();
        ArrayList<String> emailMatches = new ArrayList<String>();
        for (User user : this.userManager.getAllUsers()) {
            if (name.equalsIgnoreCase(user.getDisplayName())) {
                this.addUserKeyToList(fullNameMatches, user);
            }
            if (!name.equalsIgnoreCase(user.getEmailAddress())) continue;
            this.addUserKeyToList(emailMatches, user);
        }
        return this.pickEmailOrFullNameMatches(name, fullNameMatches, emailMatches);
    }

    private void addUserKeyToList(List<String> list, User user) {
        String key = this.userKeyService.getKeyForUsername(user.getName());
        if (key != null) {
            list.add(key);
        }
    }

    private boolean hasAnyFullNameOrEmailMatches(String name) {
        for (User user : this.userManager.getUsers()) {
            if (!name.equalsIgnoreCase(user.getDisplayName()) && !name.equalsIgnoreCase(user.getEmailAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean isEmail(String name) {
        return TextUtils.verifyEmail((String)name);
    }

    public User get(Long id) {
        ApplicationUser user = this.getApplicationUser(id);
        return user != null ? user.getDirectoryUser() : null;
    }

    public ApplicationUser getApplicationUser(Long id) {
        return this.getApplicationUser(id.toString());
    }

    public Collection<User> getAll() {
        return this.userManager.getAllUsers();
    }

    ApplicationUser getApplicationUser(String name) {
        return this.userManager.getUserByName(name);
    }
}

