/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.List;

public class MultiValueOperandHandler
implements OperandHandler<MultiValueOperand> {
    private final JqlOperandResolver operandResolver;

    public MultiValueOperandHandler(JqlOperandResolver operandResolver) {
        this.operandResolver = operandResolver;
    }

    @Override
    public MessageSet validate(User searcher, MultiValueOperand operand, TerminalClause terminalClause) {
        MessageSetImpl messages = new MessageSetImpl();
        for (Operand subOperand : operand.getValues()) {
            MessageSet subMessageSet = this.operandResolver.validate(searcher, subOperand, terminalClause);
            if (!subMessageSet.hasAnyErrors()) continue;
            messages.addMessageSet(subMessageSet);
        }
        return messages;
    }

    @Override
    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, MultiValueOperand operand, TerminalClause terminalClause) {
        ArrayList<QueryLiteral> valuesList = new ArrayList<QueryLiteral>();
        for (Operand subOperand : operand.getValues()) {
            List vals = this.operandResolver.getValues(queryCreationContext, subOperand, terminalClause);
            if (vals == null) continue;
            valuesList.addAll(vals);
        }
        return valuesList;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }
}

