/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class IssueIdClauseContextFactory
implements ClauseContextFactory {
    private final JqlIssueSupport jqlIssueSupport;
    private final JqlOperandResolver jqlOperandResolver;
    private final boolean supportsRelational;

    IssueIdClauseContextFactory(JqlIssueSupport jqlIssueSupport, JqlOperandResolver jqlOperandResolver, boolean supportsRelational) {
        this.jqlIssueSupport = jqlIssueSupport;
        this.jqlOperandResolver = jqlOperandResolver;
        this.supportsRelational = supportsRelational;
    }

    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator) || this.isNegationOperator(operator) || this.isEmptyOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals == null || literals.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<ProjectIssueTypeContextImpl> contexts = new HashSet<ProjectIssueTypeContextImpl>();
        for (QueryLiteral literal : literals) {
            if (literal.isEmpty()) continue;
            if (this.isEqualsOperator(operator)) {
                for (Issue issue : this.getIssues(searcher, literal)) {
                    contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(issue.getProjectObject().getId()), (IssueTypeContext)new IssueTypeContextImpl(issue.getIssueTypeObject().getId())));
                }
                continue;
            }
            if (!this.isRelationalOperator(operator)) continue;
            for (Issue issue : this.getIssues(searcher, literal)) {
                contexts.add(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(issue.getProjectObject().getId()), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
            }
        }
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    private boolean isEmptyOperator(Operator operator) {
        return OperatorClasses.EMPTY_ONLY_OPERATORS.contains(operator);
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean isRelationalOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }

    private boolean isEqualsOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator) || this.supportsRelational && OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator);
    }

    private Collection<Issue> getIssues(User searcher, QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.getStringValue() != null) {
            return this.jqlIssueSupport.getIssues(literal.getStringValue(), searcher);
        }
        if (literal.getLongValue() != null) {
            Issue issue = this.jqlIssueSupport.getIssue(literal.getLongValue().longValue(), searcher);
            if (issue != null) {
                return Collections.singleton(issue);
            }
            return Collections.emptySet();
        }
        throw new IllegalStateException("Invalid query literal");
    }

    @InjectableComponent
    public static class Factory {
        private final JqlIssueSupport issueSupport;
        private final JqlOperandResolver operandResolver;

        public Factory(JqlIssueSupport issueSupport, JqlOperandResolver operandResolver) {
            this.issueSupport = issueSupport;
            this.operandResolver = operandResolver;
        }

        public IssueIdClauseContextFactory create(boolean supportsRelational) {
            return new IssueIdClauseContextFactory(this.issueSupport, this.operandResolver, supportsRelational);
        }
    }
}

