/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.projectroles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.UserAwareDynaBeanTagSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public abstract class ProjectRoleTagSupport
extends UserAwareDynaBeanTagSupport {
    public static final String KEY_PROJECTROLE_ID = "projectroleid";
    public static final String KEY_PROJECTROLE_ACTORS = "actors";
    public static final String KEY_PROJECT_ID = "projectkey";
    public static final String KEY_PROJECTROLE_ACTOR_TYPE = "actortype";
    public static final String DELIMITER = ",";
    public static final String KEY_PROJECTROLE_NAME = "name";
    public static final String KEY_PROJECTROLE_DESCRIPTION = "description";

    Collection getProjectRoleActors(String projectRoleActors) {
        ArrayList<String> actors = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(projectRoleActors, DELIMITER);
        while (tokenizer.hasMoreElements()) {
            String actor = ((String)tokenizer.nextElement()).trim();
            actors.add(actor);
        }
        return actors;
    }

    protected Collection getActors() {
        ArrayList actors = new ArrayList();
        String projectRoleActors = (String)this.getProperties().get(KEY_PROJECTROLE_ACTORS);
        if (StringUtils.isNotBlank((String)projectRoleActors)) {
            actors.addAll(this.getProjectRoleActors(projectRoleActors));
        }
        return actors;
    }

    protected Project getProject() {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        Project project = null;
        String projectKey = (String)this.getProperties().get(KEY_PROJECT_ID);
        if (StringUtils.isNotBlank((String)projectKey)) {
            project = projectManager.getProjectObjByKey(projectKey);
        }
        return project;
    }

    protected ProjectRole getProjectRole(SimpleErrorCollection errorCollection) {
        ProjectRoleService projectRoleService = (ProjectRoleService)ComponentAccessor.getComponentOfType(ProjectRoleService.class);
        String projectRoleIdAsString = (String)this.getProperties().get(KEY_PROJECTROLE_ID);
        Long projectRoleId = null;
        if (StringUtils.isNotBlank((String)projectRoleIdAsString)) {
            projectRoleId = new Long(projectRoleIdAsString);
        }
        return projectRoleService.getProjectRole(projectRoleId, (ErrorCollection)errorCollection);
    }
}

