/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import java.io.IOException;
import java.io.Writer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

public abstract class IssueWriterHitCollector
extends DocumentHitCollector {
    protected final Writer writer;
    private final IssueFactory issueFactory;

    public IssueWriterHitCollector(IndexSearcher searcher, Writer writer, IssueFactory issueFactory) {
        super(searcher);
        this.writer = writer;
        this.issueFactory = issueFactory;
    }

    public void collect(Document d) {
        Issue issue = this.issueFactory.getIssue(d);
        try {
            this.writeIssue(issue, this.writer);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    protected abstract void writeIssue(Issue var1, Writer var2) throws IOException;
}

