/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelAddedEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCopiedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCreatedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueSecuritySchemeManagerImpl
extends AbstractSchemeManager
implements IssueSecuritySchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(IssueSecuritySchemeManagerImpl.class);
    private static final String SCHEME_ENTITY_NAME = "IssueSecurityScheme";
    private static final String ISSUE_SECURITY_ENTITY_NAME = "SchemeIssueSecurities";
    private static final String SCHEME_DESC = "Issue Security";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.security.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.security.default.desc";
    private static final NodeAssocationType ISSUE_SECURITY_SCHEME_ASSOCIATION = new NodeAssocationType("ProjectScheme", "Project", "IssueSecurityScheme");
    private final Cache<CacheKey, List<GenericValue>> schemeIdToSecuritiesCache;
    private final Cache<Long, List<IssueSecurityLevelPermission>> securityLevelToPermissionsCache;
    private final ProjectManager projectManager;
    private final EventPublisher eventPublisher;
    final OfBizDelegator ofBizDelegator;
    private final NodeAssociationStore nodeAssociationStore;

    public IssueSecuritySchemeManagerImpl(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, GroupManager groupManager, NodeAssociationStore nodeAssociationStore) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, ofBizDelegator, groupManager);
        this.projectManager = projectManager;
        this.eventPublisher = eventPublisher;
        this.nodeAssociationStore = nodeAssociationStore;
        this.ofBizDelegator = ofBizDelegator;
        this.schemeIdToSecuritiesCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(64).build(CacheLoader.from((Function)new SecuritiesByField("scheme")));
        new GoogleCacheInstruments(this.getClass().getSimpleName() + ".schemeIdToSecuritiesCache").addCache(this.schemeIdToSecuritiesCache).install();
        this.securityLevelToPermissionsCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(256).softValues().expireAfterAccess(30L, TimeUnit.MINUTES).build(CacheLoader.from((Function)new PermissionBySecurityLevelFunction()));
        new GoogleCacheInstruments(this.getClass().getSimpleName() + ".securityLevelToSecuritiesCache").addCache(this.securityLevelToPermissionsCache).install();
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return ISSUE_SECURITY_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing issue security scheme cache, had " + this.schemeIdToSecuritiesCache.size() + " scheme(s) and " + this.securityLevelToPermissionsCache.size() + " security level(s)"));
        }
        this.schemeIdToSecuritiesCache.invalidateAll();
        this.securityLevelToPermissionsCache.invalidateAll();
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) {
        return (List)this.schemeIdToSecuritiesCache.getUnchecked((Object)new CacheKey(scheme.getLong("id")));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long securityLevelId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntitiesBySecurityLevel(securityLevelId);
        return securities.isEmpty() || scheme.getLong("id").equals(securities.get(0).getLong("scheme")) ? securities : Collections.emptyList();
    }

    public IssueSecurityLevelScheme getIssueSecurityLevelScheme(Long issueSecuritySchemeId) {
        return Select.from(Entity.ISSUE_SECURITY_LEVEL_SCHEME).whereEqual("id", issueSecuritySchemeId).runWith(this.ofBizDelegator).singleValue();
    }

    public List<GenericValue> getEntitiesBySecurityLevel(Long securityLevelId) {
        return EntityUtils.convertToGenericValues(Entity.ISSUE_SECURITY_LEVEL_PERMISSION, this.getPermissionsBySecurityLevel(securityLevelId));
    }

    public List<IssueSecurityLevelPermission> getPermissionsBySecurityLevel(Long securityLevelId) {
        return (List)this.securityLevelToPermissionsCache.getUnchecked((Object)securityLevelId);
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.ofBizDelegator.findByAnd(ISSUE_SECURITY_ENTITY_NAME, EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter));
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Long> schemeIds = new HashSet<Long>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        return this.getSchemesByIds(schemeIds);
    }

    public void setSchemeForProject(Project project, Long schemeId) {
        this.nodeAssociationStore.removeAssociationsFromSource(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId());
        if (schemeId != null) {
            this.nodeAssociationStore.createAssociation(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId(), schemeId);
        }
        this.flushProjectSchemes();
    }

    public List<Project> getProjectsUsingScheme(long schemeId) {
        List<Long> projectIds = this.nodeAssociationStore.getSourceIdsFromSink(ISSUE_SECURITY_SCHEME_ASSOCIATION, schemeId);
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Long projectId : projectIds) {
            projects.add(this.projectManager.getProjectObj(projectId));
        }
        Collections.sort(projects, NameComparator.COMPARATOR);
        return projects;
    }

    private Collection<GenericValue> getSchemesByIds(Set<Long> schemeIds) {
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>(schemeIds.size());
        for (Long schemeId : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)schemeId));
        }
        return entityConditions.isEmpty() ? Collections.emptyList() : this.ofBizDelegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList());
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long schemeTypeId, String parameter) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField("parameter", parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Issue Security scheme IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long schemeTypeId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField("type", type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Issue Security Level IDs must be a long value.");
        }
        try {
            Long schemeId = scheme == null ? null : scheme.getLong("id");
            GenericValue result = EntityUtils.createValue(ISSUE_SECURITY_ENTITY_NAME, EasyMap.build((Object)"scheme", (Object)schemeId, (Object)"security", (Object)schemeEntity.getEntityTypeId(), (Object)"type", (Object)schemeEntity.getType(), (Object)"parameter", (Object)schemeEntity.getParameter()));
            this.eventPublisher.publish((Object)new IssueSecurityLevelAddedEvent(schemeId, schemeEntity));
            GenericValue genericValue = result;
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("security"));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue copyScheme(GenericValue scheme) throws GenericEntityException {
        if (scheme != null) {
            try {
                String name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyof", scheme.getString("name"));
                int j = 2;
                while (this.schemeExists(name)) {
                    name = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("common.words.copyxof", String.valueOf(j++), scheme.getString("name"));
                }
                GenericValue newScheme = this.createScheme(name, scheme.getString("description"));
                this.copySecurityLevels(newScheme, scheme);
                GenericValue genericValue = newScheme;
                return genericValue;
            }
            finally {
                this.clearCache();
            }
        }
        return null;
    }

    @Override
    public Scheme copyScheme(Scheme scheme) {
        try {
            GenericValue oldScheme = this.getScheme(scheme.getId());
            GenericValue newScheme = this.copyScheme(oldScheme);
            Scheme result = this.schemeFactory.getScheme(newScheme);
            this.eventPublisher.publish((Object)new IssueSecuritySchemeCopiedEvent(scheme, result));
            return result;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private void copySecurityLevels(GenericValue scheme, GenericValue oldScheme) throws GenericEntityException {
        List levels = this.ofBizDelegator.findByAnd("SchemeIssueSecurityLevels", EasyMap.build((Object)"scheme", (Object)oldScheme.getLong("id")));
        for (GenericValue level : levels) {
            IssueSecurityLevel newSecurityLevel = ComponentAccessor.getIssueSecurityLevelManager().createIssueSecurityLevel(scheme.getLong("id").longValue(), level.getString("name"), level.getString("description"));
            if (level.getLong("id").equals(oldScheme.getLong("defaultlevel"))) {
                scheme.set("defaultlevel", (Object)newSecurityLevel.getId());
                scheme.store();
            }
            List securities = this.ofBizDelegator.findByAnd(this.getEntityName(), EasyMap.build((Object)"scheme", (Object)oldScheme.getLong("id"), (Object)"security", (Object)level.getLong("id")));
            for (GenericValue security : securities) {
                this.createSchemeEntity(scheme, new SchemeEntity(security.getString("type"), security.getString("parameter"), (Object)newSecurityLevel.getId()));
            }
        }
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return this.hasPermission(entityType, entity, null);
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue issue, User user, boolean issueCreation) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must NOT be null");
        }
        return this.hasPermission(entityType, issue, user);
    }

    private boolean hasPermission(Long entityType, GenericValue issue, User user) {
        if (entityType == null) {
            return true;
        }
        if (issue == null) {
            throw new IllegalArgumentException("GenericValue passed must NOT be null");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("GenericValue passed must be an Issue and not " + issue.getEntityName());
        }
        GenericValue project = this.projectManager.getProject(issue);
        try {
            List<GenericValue> schemes = this.getSchemes(project);
            for (GenericValue scheme : schemes) {
                if (scheme == null) continue;
                return this.hasPermission(issue, user, this.getEntities(scheme, entityType));
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Could not retrieve entites from the database", (Throwable)e);
        }
        return false;
    }

    private boolean hasPermission(GenericValue issue, User user, List<GenericValue> entities) {
        if (entities.isEmpty()) {
            return false;
        }
        for (SecurityType type : ManagerFactory.getIssueSecurityTypeManager().getTypes().values()) {
            for (GenericValue perm : IssueSecuritySchemeManagerImpl.filter(entities, IssueSecuritySchemeManagerImpl.withField("type", type.getType()))) {
                if (perm == null || !this.hasPermission(issue, user, type, perm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPermission(GenericValue issue, User user, SecurityType type, GenericValue perm) {
        return user == null ? type.hasPermission(issue, perm.getString("parameter")) : type.hasPermission(issue, perm.getString("parameter"), user, false);
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        super.updateScheme(scheme);
        this.eventPublisher.publish((Object)new IssueSecuritySchemeUpdatedEvent(scheme));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        try {
            GenericValue scheme = this.getScheme(id);
            this.nodeAssociationStore.removeAssociationsFromSink(scheme);
            scheme.removeRelated("Child" + this.getEntityName());
            scheme.removeRelated("ChildSchemeIssueSecurityLevels");
            scheme.remove();
            this.eventPublisher.publish((Object)new IssueSecuritySchemeDeletedEvent(id));
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        try {
            super.deleteEntity(id);
            this.eventPublisher.publish((Object)new IssueSecurityLevelDeletedEvent(id));
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scheme createSchemeObject(String name, String description) {
        try {
            Scheme scheme = super.createSchemeObject(name, description);
            if (scheme != null) {
                this.eventPublisher.publish((Object)new IssueSecuritySchemeCreatedEvent(scheme));
            }
            Scheme scheme2 = scheme;
            return scheme2;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        try {
            boolean bl = super.removeEntities(type, parameter);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    private static List<GenericValue> filter(List<GenericValue> list, Predicate<GenericValue> predicate) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(list, predicate));
    }

    private static Predicate<GenericValue> withField(final String field, final String value) {
        if (value == null) {
            return new Predicate<GenericValue>(){

                public boolean apply(GenericValue input) {
                    return input.getString(field) == null;
                }
            };
        }
        return new Predicate<GenericValue>(){

            public boolean apply(GenericValue input) {
                return value.equals(input.getString(field));
            }
        };
    }

    private final class PermissionBySecurityLevelFunction
    implements Function<Long, List<IssueSecurityLevelPermission>> {
        private PermissionBySecurityLevelFunction() {
        }

        public List<IssueSecurityLevelPermission> apply(@Nullable Long input) {
            return Select.from(Entity.ISSUE_SECURITY_LEVEL_PERMISSION).whereEqual("security", input).runWith(IssueSecuritySchemeManagerImpl.this.ofBizDelegator).asList();
        }
    }

    static class CacheKey {
        final Long id;

        CacheKey(Long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.id == null ? other.id == null : this.id.equals(other.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    class SecuritiesByField
    implements Function<CacheKey, List<GenericValue>> {
        private final String key;

        SecuritiesByField(String key) {
            this.key = (String)Assertions.notNull((String)"key", (Object)key);
        }

        public List<GenericValue> apply(CacheKey cacheKey) {
            List<GenericValue> result = IssueSecuritySchemeManagerImpl.this.ofBizDelegator.findByAnd(IssueSecuritySchemeManagerImpl.this.getEntityName(), EasyMap.build((Object)this.key, (Object)cacheKey.id));
            return result != null ? result : Collections.emptyList();
        }
    }
}

