/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;

class TextQueryValidatingVisitor
extends SimpleNavigatorCollectorVisitor
implements ClauseVisitor<Void> {
    private boolean seenQueryClauses = false;
    private String clauseName;
    private TerminalClause terminal = null;

    public TextQueryValidatingVisitor(String clauseName) {
        super(clauseName);
        this.clauseName = (String)Assertions.notNull((String)"clauseName", (Object)clauseName);
    }

    public Void visit(OrClause orClause) {
        this.validPath = false;
        return null;
    }

    public Void visit(TerminalClause terminalClause) {
        super.visit(terminalClause);
        if (terminalClause.getName().equalsIgnoreCase(this.clauseName)) {
            if (this.seenQueryClauses || !terminalClause.getOperator().equals((Object)Operator.LIKE)) {
                this.valid = false;
            } else {
                this.seenQueryClauses = true;
                this.terminal = !this.valid ? null : terminalClause;
            }
        }
        return null;
    }

    public String getTextTerminalValue(JqlOperandResolver operandResolver, User user) {
        QueryLiteral rawValue;
        if (this.terminal != null && (rawValue = operandResolver.getSingleValue(user, this.terminal.getOperand(), this.terminal)) != null && !rawValue.isEmpty()) {
            return rawValue.asString();
        }
        return null;
    }
}

