/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class ProjectAwareQuickSearchHandlerImpl
implements ProjectAwareQuickSearchHandler {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectAwareQuickSearchHandlerImpl(ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List getProjects(QuickSearchResult searchResult) {
        Collection projectIds = searchResult.getSearchParameters("pid");
        ArrayList<GenericValue> possibleProjects = new ArrayList<GenericValue>();
        if (projectIds != null && projectIds.size() == 1) {
            String projectId = (String)projectIds.iterator().next();
            GenericValue project = this.projectManager.getProject(new Long(projectId));
            possibleProjects.add(project);
        } else {
            possibleProjects.addAll(this.permissionManager.getProjects(10, this.authenticationContext.getLoggedInUser()));
        }
        return possibleProjects;
    }

    @Override
    public String getSingleProjectIdFromSearch(QuickSearchResult searchResult) {
        Collection projectIds = searchResult.getSearchParameters("pid");
        if (projectIds != null && projectIds.size() == 1) {
            return (String)projectIds.iterator().next();
        }
        return null;
    }

    @Override
    public void addProject(String projectId, QuickSearchResult searchResult) {
        searchResult.addSearchParameter("pid", projectId);
    }
}

