/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.search.IndexSearcher;

public class SearchProviderFactoryImpl
implements SearchProviderFactory {
    private final IssueIndexManager issueIndexManager;

    public SearchProviderFactoryImpl(IssueIndexManager issueIndexManager) {
        this.issueIndexManager = (IssueIndexManager)Assertions.notNull((String)"issueIndexManager", (Object)issueIndexManager);
    }

    public SearchProviderFactoryImpl() {
        this((IssueIndexManager)ComponentAccessor.getComponentOfType(IssueIndexManager.class));
    }

    public IndexSearcher getSearcher(String searcherName) {
        if ("issues".equals(searcherName)) {
            return this.issueIndexManager.getIssueSearcher();
        }
        if ("comments".equals(searcherName)) {
            return this.issueIndexManager.getCommentSearcher();
        }
        if ("changes".equals(searcherName)) {
            return this.issueIndexManager.getChangeHistorySearcher();
        }
        throw new UnsupportedOperationException("Only issue, comment and change history indexes are catered for currently");
    }
}

