/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CurrentEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueIdIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueKeyIndexer;
import com.atlassian.jira.issue.index.indexers.impl.OriginalEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ParentIssueIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SecurityIndexer;
import com.atlassian.jira.issue.index.indexers.impl.TimeSpentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VoterIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VotesIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WatcherIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.SystemClauseHandlerFactory;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.IssueIdClauseContextFactory;
import com.atlassian.jira.jql.context.IssueSecurityLevelClauseContextFactory;
import com.atlassian.jira.jql.context.MultiClauseDecoratorContextFactory;
import com.atlassian.jira.jql.context.ProjectCategoryClauseContextFactory;
import com.atlassian.jira.jql.context.SavedFilterClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.context.ValidatingDecoratorContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.IssueClauseValueSanitiser;
import com.atlassian.jira.jql.permission.IssueParentPermissionChecker;
import com.atlassian.jira.jql.permission.TimeTrackingPermissionChecker;
import com.atlassian.jira.jql.permission.VotePermissionChecker;
import com.atlassian.jira.jql.permission.WatchPermissionChecker;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.CurrentEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueIdClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueParentClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueSecurityLevelClauseQueryFactory;
import com.atlassian.jira.jql.query.LastViewedDateClauseQueryFactory;
import com.atlassian.jira.jql.query.OriginalEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.ProjectCategoryClauseQueryFactory;
import com.atlassian.jira.jql.query.SavedFilterClauseQueryFactory;
import com.atlassian.jira.jql.query.TimeSpentClauseQueryFactory;
import com.atlassian.jira.jql.query.VoterClauseQueryFactory;
import com.atlassian.jira.jql.query.VotesClauseQueryFactory;
import com.atlassian.jira.jql.query.WatcherClauseQueryFactory;
import com.atlassian.jira.jql.query.WatchesClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.CurrentEstimateValidator;
import com.atlassian.jira.jql.validator.IssueIdValidator;
import com.atlassian.jira.jql.validator.IssueParentValidator;
import com.atlassian.jira.jql.validator.IssueSecurityLevelClauseValidator;
import com.atlassian.jira.jql.validator.LastViewedDateValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.validator.OriginalEstimateValidator;
import com.atlassian.jira.jql.validator.ProjectCategoryValidator;
import com.atlassian.jira.jql.validator.SavedFilterClauseValidator;
import com.atlassian.jira.jql.validator.TimeSpentValidator;
import com.atlassian.jira.jql.validator.UserCustomFieldValidator;
import com.atlassian.jira.jql.validator.VotesValidator;
import com.atlassian.jira.jql.validator.WatchesValidator;
import com.atlassian.jira.jql.values.ProjectCategoryClauseValuesGenerator;
import com.atlassian.jira.jql.values.SavedFilterValuesGenerator;
import com.atlassian.jira.jql.values.SecurityLevelClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.GuardedBy;

public class DefaultSystemClauseHandlerFactory
implements SystemClauseHandlerFactory {
    private final ComponentLocator locator;
    private final ComponentFactory factory;
    private final FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory;
    @GuardedBy(value="this")
    private Collection<SearchHandler> systemClauseSearchHandlers = null;

    public DefaultSystemClauseHandlerFactory(ComponentLocator locator, ComponentFactory factory, FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory) {
        this.factory = (ComponentFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.locator = (ComponentLocator)Assertions.notNull((String)"locator", (Object)locator);
        this.fieldClausePermissionHandlerFactory = (FieldClausePermissionChecker.Factory)Assertions.notNull((String)"fieldClausePermissionHandlerFactory", (Object)fieldClausePermissionHandlerFactory);
    }

    @Override
    public synchronized Collection<SearchHandler> getSystemClauseSearchHandlers() {
        if (this.systemClauseSearchHandlers == null) {
            this.systemClauseSearchHandlers = CollectionBuilder.list((Object[])new SearchHandler[]{this.createSavedFilterSearchHandler(), this.createIssueKeySearchHandler(), this.createIssueParentSearchHandler(), this.createCurrentEstimateSearchHandler(), this.createOriginalEstimateSearchHandler(), this.createTimeSpentSearchHandler(), this.createSecurityLevelSearchHandler(), this.createVotesSearchHandler(), this.createVoterSearchHandler(), this.createWatchesSearchHandler(), this.createWatcherSearchHandler(), this.createProjectCategoryHandler(), this.createSubTaskSearchHandler(), this.createProgressSearchHandler(), this.createLastViewedHandler()});
        }
        return this.systemClauseSearchHandlers;
    }

    private SearchHandler createSavedFilterSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(SavedFilterClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(SavedFilterClauseValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SavedFilterClauseContextFactory.class);
        DefaultValuesGeneratingClauseHandler savedFilterClauseHandler = new DefaultValuesGeneratingClauseHandler((ClauseInformation)SystemSearchConstants.forSavedFilter(), clauseFactory, clauseValidator, DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER, this.decorateWithValidatingContextFactory(clauseContextFactory), new SavedFilterValuesGenerator((SearchRequestService)this.locator.getComponentInstanceOfType(SearchRequestService.class)));
        SearchHandler.ClauseRegistration savedFilterClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)savedFilterClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(savedFilterClauseRegistration));
    }

    private SearchHandler createIssueKeySearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(IssueIdClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(IssueIdValidator.class);
        IssueIdClauseContextFactory.Factory contextCreator = (IssueIdClauseContextFactory.Factory)this.locator.getComponentInstanceOfType(IssueIdClauseContextFactory.Factory.class);
        ClauseContextFactory clauseContextFactory = this.decorateWithMultiContextFactory(contextCreator.create(true));
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(this.factory.createObject(IssueClauseValueSanitiser.class));
        DefaultClauseHandler issueKeySearchHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forIssueKey(), clauseFactory, clauseValidator, clausePermissionHandler, clauseContextFactory);
        SearchHandler.ClauseRegistration savedFilterClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)issueKeySearchHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(IssueKeyIndexer.class), this.factory.createObject(IssueIdIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(savedFilterClauseRegistration));
    }

    private SearchHandler createSubTaskSearchHandler() {
        String fieldId = "subtasks";
        SubTaskManager subTaskManager = (SubTaskManager)this.locator.getComponentInstanceOfType(SubTaskManager.class);
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(new IssueParentPermissionChecker(subTaskManager));
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(clausePermissionHandler, "subtasks", new ClauseNames("subtasks"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)noOpClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createProgressSearchHandler() {
        String fieldId = "progress";
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(this.createTimeTrackingPermissionHandler(), "progress", new ClauseNames("progress"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)noOpClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createIssueParentSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(IssueParentClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(IssueParentValidator.class);
        IssueIdClauseContextFactory.Factory contextCreator = (IssueIdClauseContextFactory.Factory)this.locator.getComponentInstanceOfType(IssueIdClauseContextFactory.Factory.class);
        ClauseContextFactory clauseContextFactory = this.decorateWithMultiContextFactory(contextCreator.create(false));
        SubTaskManager subTaskManager = (SubTaskManager)this.locator.getComponentInstanceOfType(SubTaskManager.class);
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(new IssueParentPermissionChecker(subTaskManager), this.factory.createObject(IssueClauseValueSanitiser.class));
        DefaultClauseHandler issueKeySearchHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forIssueParent(), clauseFactory, clauseValidator, clausePermissionHandler, clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)issueKeySearchHandler);
        return new SearchHandler(Collections.singletonList(this.factory.createObject(ParentIssueIndexer.class)), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createCurrentEstimateSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(CurrentEstimateClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(CurrentEstimateValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler currentEstimateClauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forCurrentEstimate(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration currentEstimateClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)currentEstimateClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(CurrentEstimateIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(currentEstimateClauseRegistration));
    }

    private SearchHandler createOriginalEstimateSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(OriginalEstimateClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(OriginalEstimateValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler originalEstimateClauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forOriginalEstimate(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration originalEstimateClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)originalEstimateClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(OriginalEstimateIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(originalEstimateClauseRegistration));
    }

    private SearchHandler createTimeSpentSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(TimeSpentClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(TimeSpentValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler timeSpentClauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forTimeSpent(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration timeSpentClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)timeSpentClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(TimeSpentIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(timeSpentClauseRegistration));
    }

    private SearchHandler createSecurityLevelSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseValidator.class);
        IssueSecurityLevelManager issueSecurityLevelManager = (IssueSecurityLevelManager)this.locator.getComponentInstanceOfType(IssueSecurityLevelManager.class);
        IssueSecurityLevelClauseContextFactory.Creator issueSecurityLevelClauseContextFactoryCreator = (IssueSecurityLevelClauseContextFactory.Creator)this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseContextFactory.Creator.class);
        IssueSecurityLevelClauseContextFactory clauseContextFactory = issueSecurityLevelClauseContextFactoryCreator.create();
        DefaultValuesGeneratingClauseHandler securityLevelClauseHandler = new DefaultValuesGeneratingClauseHandler((ClauseInformation)SystemSearchConstants.forSecurityLevel(), clauseFactory, clauseValidator, this.createClausePermissionHandler(SystemSearchConstants.forSecurityLevel().getFieldId()), this.decorateWithMultiContextFactory(clauseContextFactory), new SecurityLevelClauseValuesGenerator(issueSecurityLevelManager));
        SearchHandler.ClauseRegistration securityLevelClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)securityLevelClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(SecurityIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(securityLevelClauseRegistration));
    }

    private SearchHandler createVotesSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(VotesClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(VotesValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        VoteManager voteManager = (VoteManager)this.locator.getComponentInstanceOfType(VoteManager.class);
        DefaultClauseHandler votesClauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forVotes(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new VotePermissionChecker(voteManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration votesClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)votesClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(VotesIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(votesClauseRegistration));
    }

    private SearchHandler createVoterSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(VoterClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(UserCustomFieldValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        VoteManager voteManager = (VoteManager)this.locator.getComponentInstanceOfType(VoteManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forVoters(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new VotePermissionChecker(voteManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)clauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(VoterIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createWatchesSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(WatchesClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(WatchesValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        WatcherManager watcherManager = (WatcherManager)this.locator.getComponentInstanceOfType(WatcherManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forWatches(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new WatchPermissionChecker(watcherManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)clauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(WatcherIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createWatcherSearchHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(WatcherClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(UserCustomFieldValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        WatcherManager watcherManager = (WatcherManager)this.locator.getComponentInstanceOfType(WatcherManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forWatchers(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new WatchPermissionChecker(watcherManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)clauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder((Object[])new FieldIndexer[]{this.factory.createObject(WatcherIndexer.class)});
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createProjectCategoryHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(ProjectCategoryClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(ProjectCategoryValidator.class);
        ProjectManager projectManager = (ProjectManager)this.locator.getComponentInstanceOfType(ProjectManager.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(ProjectCategoryClauseContextFactory.class);
        DefaultValuesGeneratingClauseHandler projectCategoryClauseHandler = new DefaultValuesGeneratingClauseHandler((ClauseInformation)SystemSearchConstants.forProjectCategory(), clauseFactory, clauseValidator, DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER, this.decorateWithMultiContextFactory(clauseContextFactory), new ProjectCategoryClauseValuesGenerator(projectManager));
        SearchHandler.ClauseRegistration projectCategoryClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)projectCategoryClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        return new SearchHandler(builder.asList(), null, Collections.singletonList(projectCategoryClauseRegistration));
    }

    private SearchHandler createLastViewedHandler() {
        ClauseQueryFactory clauseFactory = (ClauseQueryFactory)this.locator.getComponentInstanceOfType(LastViewedDateClauseQueryFactory.class);
        ClauseValidator clauseValidator = (ClauseValidator)this.locator.getComponentInstanceOfType(LastViewedDateValidator.class);
        ClauseContextFactory clauseContextFactory = (ClauseContextFactory)this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        DefaultClauseHandler lastViewedClauseHandler = new DefaultClauseHandler((ClauseInformation)SystemSearchConstants.forLastViewedDate(), clauseFactory, clauseValidator, DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER, clauseContextFactory);
        SearchHandler.ClauseRegistration lastViewedClauseRegistration = new SearchHandler.ClauseRegistration((ClauseHandler)lastViewedClauseHandler);
        return new SearchHandler(Collections.emptyList(), null, Collections.singletonList(lastViewedClauseRegistration));
    }

    private ClausePermissionHandler createTimeTrackingPermissionHandler() {
        ApplicationProperties applicationProperties = (ApplicationProperties)this.locator.getComponentInstanceOfType(ApplicationProperties.class);
        return new DefaultClausePermissionHandler(new TimeTrackingPermissionChecker(this.fieldClausePermissionHandlerFactory, applicationProperties));
    }

    private ClausePermissionHandler createClausePermissionHandler(String fieldId) {
        return new DefaultClausePermissionHandler(this.fieldClausePermissionHandlerFactory.createPermissionChecker(fieldId));
    }

    private ClauseContextFactory decorateWithMultiContextFactory(ClauseContextFactory factory) {
        MultiClauseDecoratorContextFactory.Factory multiFactory = (MultiClauseDecoratorContextFactory.Factory)this.locator.getComponentInstanceOfType(MultiClauseDecoratorContextFactory.Factory.class);
        return multiFactory.create(factory);
    }

    private ClauseContextFactory decorateWithValidatingContextFactory(ClauseContextFactory factory) {
        return new ValidatingDecoratorContextFactory((OperatorUsageValidator)this.locator.getComponentInstanceOfType(OperatorUsageValidator.class), factory);
    }
}

