/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkStore;
import java.util.List;

public class RemoteIssueLinkStoreImpl
implements RemoteIssueLinkStore {
    public static final String ENTITY_NAME = "RemoteIssueLink";
    private final EntityEngine entityEngine;

    public RemoteIssueLinkStoreImpl(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Override
    public RemoteIssueLink getRemoteIssueLink(Long remoteIssueLinkId) {
        return (RemoteIssueLink)this.entityEngine.selectFrom(Entity.REMOTE_ISSUE_LINK).whereEqual("id", remoteIssueLinkId).singleValue();
    }

    @Override
    public List<RemoteIssueLink> getRemoteIssueLinksForIssue(Issue issue) {
        return this.entityEngine.selectFrom(Entity.REMOTE_ISSUE_LINK).whereEqual("issueid", issue.getId()).orderBy("globalid", "id");
    }

    @Override
    public List<RemoteIssueLink> getRemoteIssueLinksByGlobalId(Issue issue, String globalId) {
        return this.entityEngine.selectFrom(Entity.REMOTE_ISSUE_LINK).whereEqual("issueid", issue.getId()).andEqual("globalid", globalId).orderBy("id");
    }

    @Override
    public RemoteIssueLink createRemoteIssueLink(RemoteIssueLink remoteIssueLink) {
        return this.entityEngine.createValue(Entity.REMOTE_ISSUE_LINK, remoteIssueLink);
    }

    @Override
    public void updateRemoteIssueLink(RemoteIssueLink remoteIssueLink) {
        this.entityEngine.updateValue(Entity.REMOTE_ISSUE_LINK, remoteIssueLink);
    }

    @Override
    public void removeRemoteIssueLink(Long remoteIssueLinkId) {
        this.entityEngine.removeValue(Entity.REMOTE_ISSUE_LINK, remoteIssueLinkId);
    }
}

