/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class IssueLinkDisplayHelper {
    private final UserHistoryManager userHistoryManager;
    private final User user;

    public IssueLinkDisplayHelper(UserHistoryManager userHistoryManager, User user) {
        this.userHistoryManager = userHistoryManager;
        this.user = user;
    }

    public Collection<String> getSortedIssueLinkTypes(Collection<IssueLinkType> linkTypes) {
        List userHistoryItems = this.userHistoryManager.getHistory(UserHistoryItem.ISSUELINKTYPE, this.user);
        final ArrayList<String> history = new ArrayList<String>();
        for (UserHistoryItem userHistoryItem : userHistoryItems) {
            history.add(StringUtils.defaultString((String)userHistoryItem.getData()));
        }
        ArrayList<String> linkTypeDesc = new ArrayList<String>();
        for (IssueLinkType linkType : linkTypes) {
            linkTypeDesc.add(linkType.getOutward());
            linkTypeDesc.add(linkType.getInward());
        }
        Collections.sort(linkTypeDesc, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1.equals(s2)) {
                    return 0;
                }
                if (!history.contains(s1) && !history.contains(s2)) {
                    return 0;
                }
                if (history.contains(s1) && !history.contains(s2)) {
                    return -1;
                }
                if (!history.contains(s1) && history.contains(s2)) {
                    return 1;
                }
                return history.indexOf(s1) - history.indexOf(s2);
            }
        });
        return Sets.newLinkedHashSet(linkTypeDesc);
    }

    public String getLastUsedLinkType() {
        List userHistoryItems = this.userHistoryManager.getHistory(UserHistoryItem.ISSUELINKTYPE, this.user);
        String selectedLinkType = "";
        if (userHistoryItems.size() > 0) {
            selectedLinkType = ((UserHistoryItem)userHistoryItems.get(0)).getData();
        }
        return selectedLinkType;
    }
}

