/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeImpl;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultIssueLinkTypeManager
implements IssueLinkTypeManager {
    private final OfBizDelegator delegator;
    private final Map<Long, GenericValue> cache = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultIssueLinkTypeManager(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIssueLinkType(String name, String outward, String inward, String style) {
        try {
            Assertions.notBlank((String)"name", (String)name);
            Assertions.notBlank((String)"outward", (String)outward);
            Assertions.notBlank((String)"inward", (String)inward);
            this.delegator.createValue("IssueLinkType", EasyMap.build((Object)"linkname", (Object)name, (Object)"outward", (Object)outward, (Object)"inward", (Object)inward, (Object)"style", (Object)style));
        }
        finally {
            this.clearCache();
        }
    }

    public IssueLinkType getIssueLinkType(Long id) {
        return this.getIssueLinkType(id, true);
    }

    public IssueLinkType getIssueLinkType(Long id, boolean excludeSystemLinks) {
        GenericValue linkTypeGV;
        if (this.cache.isEmpty()) {
            this.getIssueLinkTypes(excludeSystemLinks);
        }
        return (linkTypeGV = this.cache.get(id)) != null ? this.buildIssueLinkType(linkTypeGV) : null;
    }

    public Collection getIssueLinkTypesByName(String name) {
        return this.buildIssueLinkTypes(this.queryDatabase("IssueLinkType", EasyMap.build((Object)"linkname", (Object)name)), false);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByInwardDescription(final String desc) {
        Predicate<GenericValue> inwardNamePredicate = new Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return input.getString("inward").equalsIgnoreCase(desc);
            }
        };
        return this.getIssueLinkTypesByPredicate(inwardNamePredicate);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByOutwardDescription(final String desc) {
        Predicate<GenericValue> inwardNamePredicate = new Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return input.getString("outward").equalsIgnoreCase(desc);
            }
        };
        return this.getIssueLinkTypesByPredicate(inwardNamePredicate);
    }

    private Collection<IssueLinkType> getIssueLinkTypesByPredicate(Predicate<GenericValue> predicate) {
        List inwardLinkTypes = CollectionUtil.toList((Iterable)CollectionUtil.filter(this.queryDatabase("IssueLinkType", MapBuilder.emptyMap()), predicate));
        return this.buildIssueLinkTypes(inwardLinkTypes, false);
    }

    public Collection getIssueLinkTypesByStyle(String style) {
        return this.buildIssueLinkTypes(this.queryDatabase("IssueLinkType", EasyMap.build((Object)"style", (Object)style)), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueLinkType(IssueLinkType issueLinkType, String name, String outward, String inward) {
        try {
            GenericValue gvIssueLinkType = issueLinkType.getGenericValue();
            gvIssueLinkType.set("linkname", (Object)name);
            gvIssueLinkType.set("outward", (Object)outward);
            gvIssueLinkType.set("inward", (Object)inward);
            issueLinkType.store();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIssueLinkType(Long issueLinkTypeId) {
        try {
            this.deleteFromDatabase("IssueLinkType", EasyMap.build((Object)"id", (Object)issueLinkTypeId));
        }
        finally {
            this.clearCache();
        }
    }

    public Collection<IssueLinkType> getIssueLinkTypes() {
        return this.getIssueLinkTypes(true);
    }

    public Collection<IssueLinkType> getIssueLinkTypes(boolean excludeSystemLinks) {
        List result = this.cache.values();
        if (result.isEmpty() && (result = this.delegator.findAll("IssueLinkType", EasyList.build((Object)"linkname ASC"))) != null && !result.isEmpty()) {
            for (GenericValue gv : result) {
                this.cache.put(gv.getLong("id"), gv);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return this.buildIssueLinkTypes(result, excludeSystemLinks);
    }

    private List<IssueLinkType> buildIssueLinkTypes(Collection<GenericValue> issueLinkTypeGVs, boolean excludeSystemLinks) {
        ArrayList<IssueLinkType> issueLinkTypes = new ArrayList<IssueLinkType>();
        for (GenericValue issueLinkTypeGV : issueLinkTypeGVs) {
            IssueLinkType ilt = this.buildIssueLinkType(issueLinkTypeGV);
            if (excludeSystemLinks && ilt.isSystemLinkType()) continue;
            issueLinkTypes.add(ilt);
        }
        return issueLinkTypes;
    }

    private void clearCache() {
        this.cache.clear();
    }

    private IssueLinkType buildIssueLinkType(GenericValue linkTypeGV) {
        return new IssueLinkTypeImpl(linkTypeGV);
    }

    private List<GenericValue> queryDatabase(String entityName, Map<String, Object> criteria) {
        return this.queryDatabase(entityName, criteria, Collections.EMPTY_LIST);
    }

    private List<GenericValue> queryDatabase(String entityName, Map<String, Object> criteria, List<String> sortOrder) {
        return this.delegator.findByAnd(entityName, criteria, sortOrder);
    }

    private void deleteFromDatabase(String entityName, Map<String, ?> criteria) {
        this.delegator.removeByAnd(entityName, criteria);
    }
}

