/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.AbstractLayout;
import com.atlassian.jira.issue.fields.layout.column.AbstractColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.jql.context.QueryContext;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class ColumnLayoutImpl
extends AbstractLayout
implements ColumnLayout {
    private ColumnLayout.ColumnConfig columnConfig;
    private List<ColumnLayoutItem> columnLayoutItems;

    public ColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems) {
        this(columnLayoutItems, ColumnLayout.ColumnConfig.NONE);
    }

    public ColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ColumnLayout.ColumnConfig columnConfig) {
        this.columnLayoutItems = columnLayoutItems;
        this.columnConfig = columnConfig;
    }

    public List<ColumnLayoutItem> getAllVisibleColumnLayoutItems(User user) throws ColumnLayoutException {
        try {
            Set availableFields = this.getFieldManager().getAvailableNavigableFieldsWithScope(user);
            return this.getVisibleColumnLayoutItems(availableFields);
        }
        catch (FieldException e) {
            throw new ColumnLayoutException((Throwable)e);
        }
    }

    public List<ColumnLayoutItem> getVisibleColumnLayoutItems(User user, QueryContext queryContext) throws ColumnLayoutException {
        try {
            Set availableFields = this.getFieldManager().getAvailableNavigableFieldsWithScope(user, queryContext);
            return this.getVisibleColumnLayoutItems(availableFields);
        }
        catch (FieldException e) {
            throw new ColumnLayoutException((Throwable)e);
        }
    }

    private List<ColumnLayoutItem> getVisibleColumnLayoutItems(Set<NavigableField> availableFields) throws ColumnLayoutException {
        LinkedList<ColumnLayoutItem> visibleColumns = new LinkedList<ColumnLayoutItem>();
        for (ColumnLayoutItem layoutItem : this.getInternalList()) {
            if (!availableFields.contains(layoutItem.getNavigableField())) continue;
            visibleColumns.add(layoutItem);
        }
        return visibleColumns;
    }

    public boolean contains(NavigableField navigableField) {
        for (ColumnLayoutItem columnLayoutItem : this.getInternalList()) {
            if (!columnLayoutItem.getNavigableField().equals(navigableField)) continue;
            return true;
        }
        return false;
    }

    public List<String> asFieldNames() {
        return Lists.transform(this.getInternalList(), AbstractColumnLayoutManager.ITEM_TO_FIELD_ID);
    }

    public ColumnLayout.ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    protected List<ColumnLayoutItem> getInternalList() {
        return this.columnLayoutItems;
    }

    protected FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }
}

