/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItemImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.DefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableDefaultColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableUserColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserKeyService;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractColumnLayoutManager
implements ColumnLayoutManager {
    private static final Logger log = Logger.getLogger(AbstractColumnLayoutManager.class);
    protected static final int DEFAULT_CACHE_SIZE = 200;
    static Function<ColumnLayoutItem, String> ITEM_TO_FIELD_ID = new Function<ColumnLayoutItem, String>(){

        public String apply(ColumnLayoutItem item) {
            return item.getNavigableField().getId();
        }
    };
    private final FieldManager fieldManager;
    protected final OfBizDelegator ofBizDelegator;
    private final ColumnLayout defaultColumnLayout;
    private final UserKeyService userKeyService;
    private final Map<String, List<ColumnLayoutItem>> columnLayoutCache;

    public AbstractColumnLayoutManager(FieldManager fieldManager, OfBizDelegator ofBizDelegator, UserKeyService userKeyService) {
        this.fieldManager = fieldManager;
        this.ofBizDelegator = ofBizDelegator;
        this.userKeyService = userKeyService;
        this.columnLayoutCache = Collections.synchronizedMap(new LRUMap(200));
        int position = 0;
        ArrayList<ColumnLayoutItemImpl> columnLayoutItems = new ArrayList<ColumnLayoutItemImpl>();
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuetype"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("issuekey"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("summary"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("assignee"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("reporter"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("priority"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("status"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("resolution"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("created"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("updated"), position++));
        columnLayoutItems.add(new ColumnLayoutItemImpl(fieldManager.getNavigableField("duedate"), position++));
        this.defaultColumnLayout = new DefaultColumnLayoutImpl(Collections.unmodifiableList(columnLayoutItems));
    }

    public abstract boolean hasColumnLayout(SearchRequest var1) throws ColumnLayoutStorageException;

    public abstract boolean hasColumnLayout(Long var1) throws ColumnLayoutStorageException;

    public abstract EditableSearchRequestColumnLayout getEditableSearchRequestColumnLayout(User var1, SearchRequest var2) throws ColumnLayoutStorageException;

    public abstract void storeEditableSearchRequestColumnLayout(EditableSearchRequestColumnLayout var1) throws ColumnLayoutStorageException;

    public abstract void restoreSearchRequestColumnLayout(SearchRequest var1) throws ColumnLayoutStorageException;

    public boolean hasDefaultColumnLayout() throws ColumnLayoutStorageException {
        return this.hasDefaultColumnLayout(null);
    }

    public boolean hasColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        return this.hasDefaultColumnLayout(user);
    }

    private boolean hasDefaultColumnLayout(User user) {
        String username = user != null ? user.getName() : null;
        String userKey = this.userKeyService.getKeyForUsername(username);
        GenericValue columnLayout = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null)));
        return columnLayout != null;
    }

    public ColumnLayout getColumnLayout(User remoteUser, SearchRequest searchRequest) throws ColumnLayoutStorageException {
        return this.getColumnLayout(remoteUser);
    }

    public ColumnLayout getColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            String username = remoteUser == null ? null : remoteUser.getName();
            return new UserColumnLayoutImpl(this.getColumnLayoutItems(username, availableFields), remoteUser);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout(User remoteUser) throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(remoteUser);
            return new DefaultColumnLayoutImpl(this.getColumnLayoutItems(null, availableFields));
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public ColumnLayout getDefaultColumnLayout() throws ColumnLayoutStorageException {
        return new DefaultColumnLayoutImpl(this.defaultColumnLayout.getColumnLayoutItems());
    }

    public void refresh() {
        this.columnLayoutCache.clear();
    }

    public EditableDefaultColumnLayout getEditableDefaultColumnLayout() throws ColumnLayoutStorageException {
        try {
            Set availableFields = this.fieldManager.getAllAvailableNavigableFields();
            return new EditableDefaultColumnLayoutImpl((List)this.getColumnLayoutItems(null, availableFields));
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields.", (Throwable)e);
        }
    }

    public EditableUserColumnLayout getEditableUserColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        try {
            Set availableFields = this.fieldManager.getAvailableNavigableFields(user);
            List<ColumnLayoutItem> items = this.getColumnLayoutItems(user.getName(), availableFields);
            return new EditableUserColumnLayoutImpl(items, user);
        }
        catch (FieldException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve available fields for user '" + user.getName() + "'.", (Throwable)e);
        }
    }

    protected List<ColumnLayoutItem> getColumnLayoutItems(String username, Set<NavigableField> availableFields) throws ColumnLayoutStorageException {
        String userKey = this.userKeyService.getKeyForUsername(username);
        List<ColumnLayoutItem> columnLayoutItems = this.columnLayoutCache.get(userKey);
        if (columnLayoutItems != null) {
            return columnLayoutItems;
        }
        GenericValue columnLayoutGV = null;
        if (userKey != null) {
            columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null)));
        }
        if (columnLayoutGV == null && (columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", null, (Object)"searchrequest", null)))) == null) {
            columnLayoutItems = this.removeUnavailableColumnLayoutItems(this.defaultColumnLayout.getColumnLayoutItems(), availableFields);
            this.columnLayoutCache.put(userKey, columnLayoutItems);
            return columnLayoutItems;
        }
        try {
            columnLayoutItems = this.verifyColumnLayoutItems(columnLayoutGV, availableFields);
            this.columnLayoutCache.put(userKey, columnLayoutItems);
            return columnLayoutItems;
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not retrieve the Column Layout Items.", (Throwable)e);
        }
    }

    protected List<ColumnLayoutItem> verifyColumnLayoutItems(GenericValue columnLayoutGV, Set<NavigableField> availableFields) throws GenericEntityException {
        List<ColumnLayoutItem> columnLayoutItems = new ArrayList<ColumnLayoutItem>();
        List columnLayoutItemGVs = columnLayoutGV.getRelatedOrderBy("ChildColumnLayoutItem", EasyList.build((Object)"horizontalposition ASC"));
        for (GenericValue columnLayoutItemGV : columnLayoutItemGVs) {
            if (!this.fieldManager.isNavigableField(columnLayoutItemGV.getString("fieldidentifier"))) continue;
            NavigableField navigableField = this.fieldManager.getNavigableField(columnLayoutItemGV.getString("fieldidentifier"));
            columnLayoutItems.add(new ColumnLayoutItemImpl(navigableField, columnLayoutItemGV.getLong("horizontalposition").intValue()));
        }
        columnLayoutItems = this.removeUnavailableColumnLayoutItems(columnLayoutItems, availableFields);
        return columnLayoutItems;
    }

    private List<ColumnLayoutItem> removeUnavailableColumnLayoutItems(List<ColumnLayoutItem> columnLayoutItems, Set availableFields) {
        ArrayList<ColumnLayoutItem> availableColumnLyaoutItems = new ArrayList<ColumnLayoutItem>();
        for (ColumnLayoutItem columnLayoutItem : columnLayoutItems) {
            if (!availableFields.contains(columnLayoutItem.getNavigableField())) continue;
            availableColumnLyaoutItems.add(columnLayoutItem);
        }
        return availableColumnLyaoutItems;
    }

    public void storeEditableDefaultColumnLayout(EditableDefaultColumnLayout editableDefaultColumnLayout) throws ColumnLayoutStorageException {
        this.storeEditableColumnLayout((ColumnLayout)editableDefaultColumnLayout, null);
        this.columnLayoutCache.clear();
    }

    public void storeEditableUserColumnLayout(EditableUserColumnLayout editableUserColumnLayout) throws ColumnLayoutStorageException {
        String userName = editableUserColumnLayout.getUser().getName();
        String userKey = this.userKeyService.getKeyForUsername(userName);
        if (userKey == null) {
            throw new IllegalArgumentException("The associated user '" + userName + "' does not exist");
        }
        this.storeEditableColumnLayout((ColumnLayout)editableUserColumnLayout, userKey);
        this.columnLayoutCache.remove(userKey);
    }

    private synchronized void storeEditableColumnLayout(ColumnLayout columnLayout, String userKey) throws ColumnLayoutStorageException {
        try {
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null)));
            if (columnLayoutGV == null) {
                columnLayoutGV = EntityUtils.createValue("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null));
            }
            this.storeColumnLayoutItems(columnLayoutGV, columnLayout);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            throw new ColumnLayoutStorageException("Could not load ColumnLayout", (Throwable)e);
        }
    }

    protected void storeColumnLayoutItems(GenericValue columnLayoutGV, ColumnLayout columnLayout) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        List columnLayoutItems = columnLayout.getColumnLayoutItems();
        for (int i = 0; i < columnLayoutItems.size(); ++i) {
            ColumnLayoutItem columnLayoutItem = (ColumnLayoutItem)columnLayoutItems.get(i);
            EntityUtils.createValue("ColumnLayoutItem", EasyMap.build((Object)"columnlayout", (Object)columnLayoutGV.getLong("id"), (Object)"fieldidentifier", (Object)columnLayoutItem.getNavigableField().getId(), (Object)"horizontalposition", (Object)new Long(i)));
        }
    }

    public void restoreDefaultColumnLayout() throws ColumnLayoutStorageException {
        this.restoreColumnLayout(null, null);
        this.columnLayoutCache.clear();
    }

    public void restoreUserColumnLayout(User user) throws ColumnLayoutStorageException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        String userKey = this.userKeyService.getKeyForUser(user);
        if (userKey == null) {
            log.warn((Object)("Unable to restore column layout for nonexistant user '" + user.getName() + '\''));
            return;
        }
        this.restoreColumnLayout(userKey, user.getName());
        this.columnLayoutCache.remove(userKey);
    }

    private synchronized void restoreColumnLayout(String userKey, String username) throws ColumnLayoutStorageException {
        try {
            GenericValue columnLayoutGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("ColumnLayout", EasyMap.build((Object)"username", (Object)userKey, (Object)"searchrequest", null)));
            if (columnLayoutGV != null) {
                this.removeColumnLayoutItems(columnLayoutGV);
            } else {
                log.warn((Object)("User with userkey '" + userKey + "' is already using the default layout."));
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error removing column layout for username " + username + "."), (Throwable)e);
            throw new ColumnLayoutStorageException("Error removing column layout for username " + username + ".", (Throwable)e);
        }
    }

    protected void removeColumnLayoutItems(GenericValue columnLayoutGV) throws GenericEntityException {
        List columnLayoutItemGVs = columnLayoutGV.getRelated("ChildColumnLayoutItem");
        this.ofBizDelegator.removeAll(columnLayoutItemGVs);
        columnLayoutGV.remove();
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }
}

