/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueConstantsField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.ResolutionRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ResolutionJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.operation.WorkflowIssueOperation;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ResolutionSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.ResolutionStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class ResolutionSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
IssueConstantsField,
RestAwareField,
RestFieldOperations {
    public static final Long UNRESOLVED_VALUE = -1L;
    public static final String UNRESOLVED_OPERAND = "Unresolved";
    private static final String RESOLUTION_NAME_KEY = "issue.field.resolution";
    private final ConstantsManager constantsManager;
    private final ResolutionStatisticsMapper resolutionStatisticsMapper;
    private final UserHistoryManager userHistoryManager;
    private final JiraBaseUrls jiraBaseUrls;

    public ResolutionSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, ConstantsManager constantsManager, JiraAuthenticationContext authenticationContext, ResolutionStatisticsMapper resolutionStatisticsMapper, PermissionManager permissionManager, ResolutionSearchHandlerFactory searchHandlerFactory, UserHistoryManager userHistoryManager, JiraBaseUrls jiraBaseUrls) {
        super("resolution", RESOLUTION_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.constantsManager = constantsManager;
        this.resolutionStatisticsMapper = resolutionStatisticsMapper;
        this.userHistoryManager = userHistoryManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        if (operationContext != null) {
            velocityParams.put(this.getId(), operationContext.getFieldValuesHolder().get(this.getId()));
        }
        velocityParams.put("resolutions", this.retrieveResolutions(operationContext, (IssueContext)issue, velocityParams));
        return this.renderTemplate("resolution-edit.vm", velocityParams);
    }

    Collection<Resolution> retrieveResolutions(final OperationContext operationContext, IssueContext issue, Map<String, Object> velocityParams) {
        Predicate resolutionIncluder = new Predicate(){
            final Collection excludeResolutionIds;
            final Collection includeResolutionIds;
            {
                this.excludeResolutionIds = ResolutionSystemField.this.getIncludeResolutionIds(operationContext, "jira.field.resolution.exclude");
                this.includeResolutionIds = ResolutionSystemField.this.getIncludeResolutionIds(operationContext, "jira.field.resolution.include");
            }

            public boolean evaluate(Object arg) {
                Resolution resolution = (Resolution)arg;
                if (!((Object)this.excludeResolutionIds).equals(Collections.EMPTY_LIST)) {
                    return !this.excludeResolutionIds.contains(resolution.getId());
                }
                if (!((Object)this.includeResolutionIds).equals(Collections.EMPTY_LIST)) {
                    return this.includeResolutionIds.contains(resolution.getId());
                }
                return true;
            }
        };
        ArrayList resolutions = new ArrayList(this.constantsManager.getResolutionObjects());
        CollectionUtils.filter(resolutions, (Predicate)resolutionIncluder);
        return Collections.unmodifiableCollection(resolutions);
    }

    Collection getIncludeResolutionIds(OperationContext operationContext, String resolutionType) {
        String[] resolutionIds;
        Map metaAttributes;
        String resolutionIdString;
        WorkflowIssueOperation issueOperation;
        ActionDescriptor wfAction;
        if (operationContext != null && operationContext.getIssueOperation() instanceof WorkflowIssueOperation && (wfAction = (issueOperation = (WorkflowIssueOperation)operationContext.getIssueOperation()).getActionDescriptor()) != null && !StringUtils.isBlank((String)(resolutionIdString = (String)(metaAttributes = wfAction.getMetaAttributes()).get(resolutionType))) && (resolutionIds = StringUtils.split((String)resolutionIdString, (String)",")) != null) {
            return Arrays.asList(resolutionIds);
        }
        return Collections.EMPTY_LIST;
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Resolution resolution = issue.getResolutionObject();
        velocityParams.put("resolution", resolution);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        GenericValue resolutionGV = (GenericValue)value;
        Resolution resolution = this.constantsManager.getResolutionObject(resolutionGV.getString("id"));
        velocityParams.put("resolution", resolution);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map<String, Object> velocityParams) {
        return this.renderTemplate("resolution-view.vm", velocityParams);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String resolutionId = (String)fieldValuesHolder.get(this.getId());
        if (TextUtils.stringSet((String)resolutionId)) {
            if (this.getValueFromParams(fieldValuesHolder) == null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.invalidresolution"));
            } else if (this.getIncludeResolutionIds(operationContext, "jira.field.resolution.exclude").contains(resolutionId)) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.excludedresolution"));
            } else if (!((Object)this.getIncludeResolutionIds(operationContext, "jira.field.resolution.include")).equals(Collections.EMPTY_LIST) && !this.getIncludeResolutionIds(operationContext, "jira.field.resolution.include").contains(resolutionId)) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("field.error.excludedresolution"));
            }
            return;
        }
        if (fieldScreenRenderLayoutItem.isRequired() && !TextUtils.stringSet((String)resolutionId)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
        }
    }

    public Object getValueFromParams(Map params) {
        String resolutionId = (String)params.get(this.getId());
        if (TextUtils.stringSet((String)resolutionId)) {
            return this.constantsManager.getResolution(resolutionId);
        }
        return null;
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        Long resolutionId;
        try {
            resolutionId = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            resolutionId = this.getResolutionIdByName(stringValue);
        }
        fieldValuesHolder.put(this.getId(), resolutionId.toString());
    }

    private Long getResolutionIdByName(String stringValue) throws FieldValidationException {
        for (GenericValue resolutionGV : this.constantsManager.getResolutions()) {
            if (!stringValue.equalsIgnoreCase(resolutionGV.getString("name"))) continue;
            return Long.valueOf(resolutionGV.getString("id"));
        }
        throw new FieldValidationException("Invalid resolution name '" + stringValue + "'.");
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                GenericValue resolution = (GenericValue)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, resolution.getString("id"), resolution.getString("name"));
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            GenericValue currentResolution = (GenericValue)currentValue;
            if (value != null) {
                GenericValue resolution = (GenericValue)value;
                cib = new ChangeItemBean("jira", this.getId(), currentResolution.getString("id"), currentResolution.getString("name"), resolution.getString("id"), resolution.getString("name"));
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentResolution.getString("id"), currentResolution.getString("name"), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        String resolutionId = issue.getString(this.getId());
        if (resolutionId == null) {
            resolutionId = this.getApplicationProperties().getString("jira.constant.default.resolution");
        }
        fieldValuesHolder.put(this.getId(), resolutionId);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), this.getApplicationProperties().getString("jira.constant.default.resolution"));
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            GenericValue resolution = (GenericValue)this.getValueFromParams(fieldValueHolder);
            issue.setResolution(resolution);
            if (resolution != null) {
                this.userHistoryManager.addItemToHistory(UserHistoryItem.RESOLUTION, this.authenticationContext.getLoggedInUser(), resolution.getString("id"), resolution.getString("name"));
            }
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Object originalIssue1 : originalIssues) {
            Issue originalIssue = (Issue)originalIssue1;
            if (originalIssue.getResolution() != null || !targetFieldLayoutItem.isRequired()) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setResolution(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getResolution() != null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.resolution";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.resolutionStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        GenericValue resolutionGV = issue.getResolution();
        if (resolutionGV != null) {
            Resolution resolution = issue.getResolutionObject();
            velocityParams.put(this.getId(), resolution);
        }
        return this.renderTemplate("resolution-columnview.vm", velocityParams);
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.constantsManager.getResolutionObjects().isEmpty()) {
            return "bulk.edit.unavailable.noresolutions";
        }
        for (FieldLayout fieldLayout : bulkEditBean.getFieldLayouts()) {
            if (!fieldLayout.isFieldHidden(this.getId())) continue;
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public Collection getIssueConstants() {
        return this.constantsManager.getResolutionObjects();
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        Resolution resolution;
        Long resolutionId;
        if (TextUtils.stringSet((String)changeHistory) && (resolutionId = this.getResolutionIdByName(changeHistory)) != null && (resolution = this.constantsManager.getResolutionObject(resolutionId.toString())) != null) {
            return resolution.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        Collection<Resolution> allowedResolutions = this.retrieveResolutions(fieldTypeInfoContext.getOperationContext(), fieldTypeInfoContext.getIssueContext(), velocityParams);
        return new FieldTypeInfo(allowedResolutions, null);
    }

    public JsonType getJsonSchema() {
        return ResolutionSystemField.getResolutionJsonSchema(true);
    }

    public static JsonType getResolutionJsonSchema(boolean nullable) {
        return JsonTypeBuilder.system((String)"resolution", (String)"resolution");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)ResolutionJsonBean.shortBean((Resolution)issue.getResolutionObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new ResolutionRestFieldOperationsHandler(this.constantsManager, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

