/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.parameters.lucene.sort.MappedSortComparator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.velocity.exception.VelocityException;

public abstract class NavigableFieldImpl
extends AbstractField
implements NavigableField {
    private static final Logger log = Logger.getLogger(NavigableFieldImpl.class);
    private final String columnHeadingKey;
    protected final VelocityTemplatingEngine templatingEngine;
    protected final ApplicationProperties applicationProperties;
    private String defaultSortOrder;

    public NavigableFieldImpl(String id, String nameKey, String columnHeadingKey, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super(id, nameKey, authenticationContext);
        this.columnHeadingKey = columnHeadingKey;
        this.templatingEngine = templatingEngine;
        this.applicationProperties = applicationProperties;
        this.defaultSortOrder = null;
    }

    public NavigableFieldImpl(String id, String nameKey, String columnHeadingKey, String defaultSortOrder, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        super(id, nameKey, authenticationContext);
        this.columnHeadingKey = columnHeadingKey;
        this.templatingEngine = templatingEngine;
        this.applicationProperties = applicationProperties;
        this.defaultSortOrder = defaultSortOrder;
    }

    public String getColumnHeadingKey() {
        return this.columnHeadingKey;
    }

    public String getColumnCssClass() {
        return this.getId();
    }

    public String getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    void setDefaultSortOrder(String s) {
        this.defaultSortOrder = s;
    }

    public FieldComparatorSource getSortComparatorSource() {
        LuceneFieldSorter sorter = this.getSorter();
        if (sorter == null) {
            return null;
        }
        return new MappedSortComparator(sorter);
    }

    public List<SortField> getSortFields(boolean sortOrder) {
        FieldComparatorSource sorter = this.getSortComparatorSource();
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        if (sorter != null) {
            String fieldName = this.getSorter() != null ? this.getSorter().getDocumentConstant() : "field_" + this.getId();
            SortField sortField = new SortField(fieldName, sorter, sortOrder);
            sortFields.add(sortField);
        }
        return sortFields;
    }

    protected String renderTemplate(String template, Map velocityParams) {
        try {
            return this.templatingEngine.render(TemplateSources.file((String)("templates/jira/issue/field/" + template))).applying(velocityParams).asHtml();
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for 'templates/jira/issue/field//" + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected Map<String, Object> getVelocityParams(FieldLayoutItem fieldLayoutItem, I18nHelper i18nHelper, Map displayParams, Issue issue) {
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("req", ExecutingHttpRequest.get());
        velocityParams.put("field", this);
        velocityParams.put("i18n", i18nHelper);
        velocityParams.put("urlcodec", new URLCodec());
        velocityParams.put("issue", issue);
        velocityParams.put("displayParams", displayParams);
        velocityParams.put("fieldLayoutItem", fieldLayoutItem);
        return CompositeMap.of(velocityParams, JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext));
    }

    public String getHiddenFieldId() {
        return null;
    }

    protected ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public String prettyPrintChangeHistory(String changeHistory) {
        return changeHistory;
    }

    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        return changeHistory;
    }
}

