/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.fields.option.AssigneeOption;
import com.atlassian.jira.issue.fields.option.AssigneeOptions;
import com.atlassian.jira.issue.fields.option.OptionGroup;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Assignees {
    private static final String SEPERATOR_STRING = "---------------";
    private final AssigneeService assigneeService;
    private final JiraAuthenticationContext authenticationContext;
    private final AvatarService avatarService;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;

    public Assignees(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, AssigneeService assigneeService, AvatarService avatarService, UserManager userManager) {
        this.assigneeService = assigneeService;
        this.authenticationContext = authenticationContext;
        this.avatarService = avatarService;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
    }

    List<AssigneeOption> optionsForHtmlSelect(Issue issue, ActionDescriptor actionDescriptor) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        List assignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        return this.makeAssigneeOptionsList(assignableUsers, suggestedAssignees);
    }

    AssigneeOptions optionsForFrotherControl(Issue issue, ActionDescriptor actionDescriptor, String currentAssigneeUsername) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, actionDescriptor);
        User assignee = issue.getAssignee();
        if (assignee == null && currentAssigneeUsername != null && (assignee = this.userManager.getUserObject(currentAssigneeUsername)) != null && this.isAssignable(assignee, Collections.singletonList(issue), actionDescriptor)) {
            suggestedAssignees.add(assignee);
            Collections.sort(suggestedAssignees, new UserBestNameComparator(this.authenticationContext.getLocale()));
        }
        AssigneeOptions assigneeOptions = this.makeAssigneeOptions(Collections.singletonList(issue), actionDescriptor, suggestedAssignees, assignee, this.isNew(issue));
        if (assignee != null && !assignee.getName().equals(currentAssigneeUsername)) {
            assigneeOptions.setInvalidAssigneeSelected(true);
        }
        return assigneeOptions;
    }

    AssigneeOptions bulkOptionsForFrotherControl(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        HashSet<String> suggestedAssigneeNames = new HashSet<String>();
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser != null) {
            suggestedAssigneeNames.add(loggedInUser.getName());
        }
        List bulkAssignableUsers = this.assigneeService.getAssignableUsers(issues, actionDescriptor);
        for (Issue issue : issues) {
            suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForIssue(issue));
        }
        suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForUser(loggedInUser));
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(suggestedAssigneeNames, bulkAssignableUsers);
        return this.makeAssigneeOptions(issues, actionDescriptor, suggestedAssignees, null, true);
    }

    List<AssigneeOption> bulkOptionsForHtmlSelect(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        List bulkAssignableUsers = null;
        HashSet suggestedAssigneeNames = new HashSet();
        for (Issue issue : issues) {
            List issueAssignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
            if (bulkAssignableUsers == null) {
                bulkAssignableUsers = issueAssignableUsers;
            } else {
                bulkAssignableUsers.retainAll(issueAssignableUsers);
            }
            suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForIssue(issue));
        }
        Collections.sort(bulkAssignableUsers, new UserBestNameComparator(this.authenticationContext.getLocale()));
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForUser(loggedInUser));
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(suggestedAssigneeNames, bulkAssignableUsers);
        return this.makeAssigneeOptionsList(bulkAssignableUsers, suggestedAssignees);
    }

    private List<AssigneeOption> makeAssigneeOptionsList(List<User> assignableUsers, List<User> suggestedUsers) {
        ArrayList<AssigneeOption> options = new ArrayList<AssigneeOption>();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        if (this.isUnassignedIssuesEnabled()) {
            options.add(new AssigneeOption(null, i18n.getText("common.concepts.unassigned"), true));
        }
        options.add(new AssigneeOption("-1", "- " + i18n.getText("common.concepts.automatic") + " -", true));
        AssigneeOption separator = new AssigneeOption("-2", SEPERATOR_STRING, false);
        separator.setOptionEnabled(false);
        options.add(separator);
        Map uniqueFullNames = this.assigneeService.makeUniqueFullNamesMap(assignableUsers);
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (!suggestedUsers.isEmpty()) {
            for (User suggestedUser : suggestedUsers) {
                options.add(this.createAssigneeOption(suggestedUser, loggedInUser, uniqueFullNames));
            }
            options.add(separator);
        }
        for (User user : assignableUsers) {
            options.add(this.createAssigneeOption(user, loggedInUser, uniqueFullNames));
        }
        return options;
    }

    private AssigneeOptions makeAssigneeOptions(Collection<Issue> issues, ActionDescriptor actionDescriptor, List<User> suggestedUsers, User currentAssignee, boolean assignAutomaticIfUnassigned) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        AssigneeOptions options = new AssigneeOptions();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        OptionGroup suggestedAssignees = new OptionGroup("suggested", i18n.getText("assignee.picker.group.suggested"), null, 0);
        if (suggestedUsers.contains(loggedInUser)) {
            suggestedUsers.remove(loggedInUser);
            AssigneeOption assignToMe = this.createAssigneeOption(loggedInUser, loggedInUser, null);
            suggestedAssignees.add(assignToMe);
        }
        String defaultAvatarURL = this.avatarService.getAvatarURL(loggedInUser, null, Avatar.Size.SMALL).toString();
        AssigneeOption unassignedAssignee = new AssigneeOption("", i18n.getText("common.concepts.unassigned"), "", defaultAvatarURL);
        if (this.isUnassignedIssuesEnabled()) {
            suggestedAssignees.add(unassignedAssignee);
        }
        AssigneeOption automaticAssignee = new AssigneeOption("-1", i18n.getText("common.concepts.automatic"), "", defaultAvatarURL);
        if (currentAssignee == null) {
            if (assignAutomaticIfUnassigned) {
                automaticAssignee.setSelected(true);
            } else if (this.isUnassignedIssuesEnabled()) {
                unassignedAssignee.setSelected(true);
            }
        }
        suggestedAssignees.add(automaticAssignee);
        for (User suggestedUser : suggestedUsers) {
            AssigneeOption assigneeOption = this.createAssigneeOption(suggestedUser, loggedInUser, null);
            if (suggestedUser.equals(loggedInUser)) {
                assigneeOption.setLoggedInUser(true);
            }
            if (currentAssignee != null && suggestedUser.equals(currentAssignee)) {
                assigneeOption.setSelected(true);
            }
            suggestedAssignees.add(assigneeOption);
        }
        options.add(suggestedAssignees);
        if (loggedInUser != null && !loggedInUser.equals(currentAssignee)) {
            options.setLoggedInUserIsAssignable(this.isAssignable(loggedInUser, issues, actionDescriptor));
        }
        return options;
    }

    private boolean isAssignable(User loggedInUser, Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        boolean loggedInUserIsAssignable = true;
        if (!Users.isAnonymous((User)loggedInUser)) {
            for (Issue issue : issues) {
                Collection matches = this.assigneeService.findAssignableUsers(loggedInUser.getName(), issue, actionDescriptor);
                if (matches.contains(loggedInUser)) continue;
                loggedInUserIsAssignable = false;
                break;
            }
        }
        return loggedInUserIsAssignable;
    }

    private AssigneeOption createAssigneeOption(User user, User loggedInUser, @Nullable Map<String, Boolean> fullNames) {
        boolean isUnique;
        String displayName = user.getDisplayName();
        boolean bl = isUnique = fullNames == null || fullNames.get(displayName) != false;
        if (!isUnique) {
            displayName = displayName + " (" + user.getName() + ")";
        }
        URI avatarURL = this.avatarService.getAvatarURL(loggedInUser, user.getName(), Avatar.Size.SMALL);
        return new AssigneeOption(user.getName(), displayName, user.getEmailAddress(), avatarURL.toString());
    }

    private boolean isNew(Issue issue) {
        return issue.getId() == null;
    }

    private boolean isUnassignedIssuesEnabled() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }
}

